/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.model;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import con.sleys.lazyutilities.LazyUtilitiesMod;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelWeaponLecter {
    public static final Logger LOGGER = LogManager.getLogger(LazyUtilitiesMod.class);
    private static final Map<ResourceLocation, BladeLength> bladeLengths = new HashMap<ResourceLocation, BladeLength>();
    private static final Map<ResourceLocation, BladeLength> tagBladeLengths = new HashMap<ResourceLocation, BladeLength>();
    private static final Map<String, List<String>> tagCompatibilities = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> weaponCompatibilities = new HashMap<String, List<String>>();

    public static void loadConfigFromAssets() {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        String directoryPath = "blade_parameters";
        try {
            Map resources = resourceManager.m_214159_(directoryPath, path -> path.m_135815_().endsWith(".json"));
            if (resources.isEmpty()) {
                LOGGER.info("[LZM: Epic Fight] No se encontraron archivos en 'blade_parameters'");
                return;
            }
            LOGGER.info("[LZM: Epic Fight] Archivos JSON encontrados en 'blade_parameters':");
            for (ResourceLocation resource : resources.keySet()) {
                LOGGER.info(" - " + String.valueOf(resource));
                ModelWeaponLecter.loadConfigFromResource(resourceManager, resource);
            }
        }
        catch (Exception e) {
            LOGGER.error("[LZM: Epic Fight] Error cargando configuraci\u00f3n de assets", (Throwable)e);
        }
    }

    private static void loadConfigFromResource(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        try {
            Optional resourceOpt = resourceManager.m_213713_(resourceLocation);
            if (resourceOpt.isEmpty()) {
                LOGGER.warn("[LZM: Epic Fight] No se pudo acceder al archivo: " + String.valueOf(resourceLocation));
                return;
            }
            InputStream stream = ((Resource)resourceOpt.get()).m_215507_();
            String json = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            Gson gson = new Gson();
            String path = resourceLocation.m_135815_();
            if (path.contains("tag_")) {
                LOGGER.info("[LZM: Epic Fight] Archivo Tag encontrado: " + String.valueOf(resourceLocation));
                Type type = new TypeToken<Map<String, BladeLength>>(){}.getType();
                Map data = (Map)gson.fromJson(json, type);
                data.forEach((key, value) -> {
                    ResourceLocation rl = ResourceLocation.m_135820_((String)key);
                    if (rl != null) {
                        tagBladeLengths.put(rl, (BladeLength)value);
                    } else {
                        LOGGER.warn("[LZM: Epic Fight] Invalid Tag in ResourceLocation: {}", key);
                    }
                });
            } else if (path.contains("weapon_")) {
                LOGGER.info("[LZM: Epic Fight] Archivo Weapon encontrado: " + String.valueOf(resourceLocation));
                Type type = new TypeToken<Map<String, BladeLength>>(){}.getType();
                Map data = (Map)gson.fromJson(json, type);
                data.forEach((key, value) -> {
                    ResourceLocation rl = ResourceLocation.m_135820_((String)key);
                    if (rl != null) {
                        bladeLengths.put(rl, (BladeLength)value);
                    } else {
                        LOGGER.warn("[LZM: Epic Fight] Invalid Weapon in ResourceLocation: {}", key);
                    }
                });
            } else if (path.contains("capability_tag_")) {
                LOGGER.info("[LZM: Epic Fight] Archivo Tag Capability encontrado: " + String.valueOf(resourceLocation));
                Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
                tagCompatibilities.putAll((Map)gson.fromJson(json, type));
            } else if (path.contains("capability_weapon_")) {
                LOGGER.info("[LZM: Epic Fight] Archivo Weapon Capability encontrado: " + String.valueOf(resourceLocation));
                Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
                weaponCompatibilities.putAll((Map)gson.fromJson(json, type));
            }
            LOGGER.info("[LZM: Epic Fight] Archivo procesado correctamente: " + String.valueOf(resourceLocation));
        }
        catch (Exception e) {
            LOGGER.error("[LZM: Epic Fight] Error procesando archivo: " + String.valueOf(resourceLocation), (Throwable)e);
        }
    }

    public static boolean isTagCompatible(String mainTag, String offTag) {
        return tagCompatibilities.getOrDefault(mainTag, Collections.emptyList()).contains(offTag);
    }

    public static boolean isWeaponCompatible(String mainWeapon, String offWeapon) {
        return weaponCompatibilities.getOrDefault(mainWeapon, Collections.emptyList()).contains(offWeapon);
    }

    public static BladeLength getBladeLength(ItemStack item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_());
        if (bladeLengths.containsKey(id)) {
            return bladeLengths.get(id);
        }
        for (Map.Entry<ResourceLocation, BladeLength> entry : tagBladeLengths.entrySet()) {
            ResourceLocation tagId = entry.getKey();
            if (!item.m_41720_().m_204114_().m_203656_(ItemTags.create((ResourceLocation)tagId))) continue;
            return entry.getValue();
        }
        return new BladeLength(0.0, 0.0, 0.0, false, false, 0.0, 1.0, 1.0, 1.0, 0.1, 0.1, 0.1);
    }

    public static class BladeLength {
        public double start;
        public double end;
        public double angle;
        public boolean rotate;
        public boolean mirror;
        public double fix_start;
        public double vol_x;
        public double vol_y;
        public double vol_z;
        public double cord_x;
        public double cord_y;
        public double cord_z;

        public BladeLength(double start, double end, double angle, boolean rotate, boolean mirror, double fix_start, double vol_x, double vol_y, double vol_z, double cord_x, double cord_y, double cord_z) {
            this.start = start;
            this.end = end;
            this.angle = angle;
            this.rotate = rotate;
            this.mirror = mirror;
            this.fix_start = fix_start;
            this.vol_x = vol_x;
            this.vol_y = vol_y;
            this.vol_z = vol_z;
            this.cord_x = cord_x;
            this.cord_y = cord_y;
            this.cord_z = cord_z;
        }
    }
}

