/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.model;

import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.modules.epicfight.model.ModelWeaponLecter;
import con.sleys.lazyutilities.network.CTSParticlePacket;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PoseParticleEngineWeaponSimple {
    private static final Logger LOGGER = LogManager.getLogger(PoseParticleEngineWeaponSimple.class);

    public static void generateHandParticles(LivingEntity entity, InteractionHand hand, SimpleParticleType particleType, float amount) {
        Joint toolJoint;
        ItemStack handItem = hand == InteractionHand.MAIN_HAND ? entity.m_21205_() : entity.m_21206_();
        ModelWeaponLecter.BladeLength bladeData = ModelWeaponLecter.getBladeLength(handItem);
        if (bladeData == null) {
            LOGGER.error("BladeLengthConfig.getBladeLength() devolvi\u00f3 NULL para: " + String.valueOf(handItem.m_41720_()));
            return;
        }
        if (bladeData.end == 0.0 && bladeData.start == 0.0) {
            return;
        }
        LinkedList<Vec3> offsets = new LinkedList<Vec3>();
        boolean isMirror = bladeData.mirror;
        boolean shouldRotate = bladeData.rotate;
        double fix = bladeData.fix_start;
        double angleRad = Math.toRadians(bladeData.angle);
        double vol_x = bladeData.vol_x;
        double vol_y = bladeData.vol_y;
        double vol_z = bladeData.vol_z;
        double cord_x = bladeData.cord_x;
        double cord_y = bladeData.cord_y;
        double cord_z = bladeData.cord_z;
        double step = Math.max(1.0, (bladeData.end - 1.0) * 5.0 + 1.0);
        if (isMirror) {
            step *= 2.0;
        }
        double setLeghtFix = 0.0;
        for (double i = 1.0; i <= bladeData.end + setLeghtFix; i += 0.1) {
            double x = -0.4;
            double y = -0.2 * i + angleRad;
            double z = bladeData.start * i;
            if (shouldRotate) {
                double temp = z;
                z = y;
                y = temp + fix;
            }
            offsets.add(new Vec3(x, y, z));
            if (!isMirror) continue;
            offsets.add(new Vec3(x, y, -z + fix));
        }
        LivingEntityPatch entityPatch = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entityPatch == null) {
            return;
        }
        Joint joint = toolJoint = hand == InteractionHand.MAIN_HAND ? entityPatch.getArmature().searchJointByName("Tool_R") : entityPatch.getArmature().searchJointByName("Tool_L");
        if (toolJoint != null) {
            PoseParticleEngineWeaponSimple.ExecuteParticlesOnArmature(toolJoint, entityPatch, particleType, amount, new Vec3(-0.1, 0.02, 0.02), offsets, step, vol_x, vol_y, vol_z, cord_x, cord_y, cord_z);
        }
    }

    private static void ExecuteParticlesOnArmature(Joint joint, LivingEntityPatch<?> entityPatch, SimpleParticleType particle, float amount, Vec3 particleSpeed, LinkedList<Vec3> offsets, double step, double vol_x, double vol_y, double vol_z, double cord_x, double cord_y, double cord_z) {
        Level world = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (float i = 1.0f; i <= 9.0f; i += 2.0f) {
            float time = (i + ((Random)random).nextFloat() - 1.0f) / 10.0f;
            Pose middlePose = entityPatch.getAnimator().getPose(time);
            Vec3 entityPos = ((LivingEntity)entityPatch.getOriginal()).m_20318_(time);
            OpenMatrix4f modelMatrix = OpenMatrix4f.createTranslation((float)((float)entityPos.f_82479_), (float)((float)entityPos.f_82480_), (float)((float)entityPos.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix(time)));
            OpenMatrix4f jointMatrix = entityPatch.getArmature().getBindedTransformFor(middlePose, joint).mulFront(modelMatrix);
            for (Vec3 offset : offsets) {
                int bound = (int)((double)(100.0f / Math.max(amount, 0.01f)) * Math.max(step, 1.0));
                if (bound <= 0 || ((Random)random).nextInt(bound) >= 40) continue;
                Vec3 randomizedOffset = offset.m_82520_((double)(((Random)random).nextFloat() - 0.5f) * vol_z, (double)(((Random)random).nextFloat() - 0.5f) * vol_x, (double)(((Random)random).nextFloat() - 0.5f) * vol_y);
                Vec3 particlePos = OpenMatrix4f.transform((OpenMatrix4f)jointMatrix, (Vec3)randomizedOffset.m_82520_(-cord_z, -cord_x, -cord_y));
                if (!world.f_46443_) continue;
                LazyUtilitiesMod.PACKET_HANDLER.sendToServer((Object)new CTSParticlePacket(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleSpeed.f_82479_, particleSpeed.f_82480_, particleSpeed.f_82481_, (ParticleOptions)particle));
            }
        }
    }
}

