/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.packers.lecter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import con.sleys.lazyutilities.LazyUtilitiesMod;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class EpicFightAssetsAccessor
extends AbstractPackResources {
    private final FileSystem fs;
    private final Path root;
    private final Path assetsRoot;
    private final Set<String> registeredPaths = new HashSet<String>();
    private final String mainNamespace;
    private File jarFile;

    public EpicFightAssetsAccessor(File jarFile, String mainNamespace) throws IOException {
        super(jarFile.getName(), false);
        this.jarFile = jarFile;
        this.mainNamespace = mainNamespace;
        if (jarFile.isDirectory()) {
            this.fs = null;
            this.root = jarFile.toPath();
        } else {
            this.fs = FileSystems.newFileSystem(jarFile.toPath(), (ClassLoader)null);
            this.root = this.fs.getPath("/", new String[0]);
        }
        this.assetsRoot = this.root.resolve("assets");
        Path metaPath = this.root.resolve("pack.mcmeta");
        if (!Files.exists(metaPath, new LinkOption[0])) {
            throw new IOException("[LZM: Epic Fight] pack.mcmeta no encontrado en: " + String.valueOf(metaPath));
        }
    }

    public IoSupplier<InputStream> m_8017_(String ... paths) {
        Path path = this.root.resolve(String.join((CharSequence)"/", paths)).normalize();
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        return IoSupplier.m_246697_((Path)path);
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        Path path = this.assetsRoot.resolve(location.m_135827_()).resolve(location.m_135815_()).normalize();
        if (!path.startsWith(this.assetsRoot)) {
            LazyUtilitiesMod.LOGGER.warn("[LZM: Epic Fight] Intento de acceso a ruta no permitida: {}", (Object)path);
            return null;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        return IoSupplier.m_246697_((Path)path);
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        Path nsRoot = this.assetsRoot.resolve(namespace).normalize();
        Path searchPath = nsRoot.resolve(path).normalize();
        if (!searchPath.startsWith(this.assetsRoot)) {
            LazyUtilitiesMod.LOGGER.warn("[LZM: Epic Fight] Ruta no permitida: {}", (Object)searchPath);
            return;
        }
        if (!Files.exists(searchPath, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(searchPath, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String relative = nsRoot.relativize((Path)file).toString().replace("\\", "/");
                if (!relative.matches("[\\w\\-./+]+")) {
                    return;
                }
                ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)relative);
                if (this.registeredPaths.add(loc.toString())) {
                    output.accept((Object)loc, (Object)IoSupplier.m_246697_((Path)file));
                }
            });
        }
        catch (IOException e) {
            LazyUtilitiesMod.LOGGER.error("[LZM: Epic Fight] Error listando recursos: {}", (Object)e.getMessage());
        }
    }

    public Set<String> m_5698_(PackType type) {
        return Collections.singleton(this.mainNamespace);
    }

    public String m_5542_() {
        return this.jarFile.toString();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        if (!"pack".equals(deserializer.m_7991_())) {
            return null;
        }
        JsonObject fallbackPack = new JsonObject();
        fallbackPack.addProperty("pack_format", (Number)15);
        JsonObject descObj = new JsonObject();
        descObj.addProperty("text", "Accessed From -> " + this.jarFile.getName());
        descObj.addProperty("color", "aqua");
        fallbackPack.add("description", (JsonElement)descObj);
        return (T)deserializer.m_6322_(fallbackPack);
    }

    public void close() {
        try {
            if (this.fs != null && this.fs.isOpen()) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            LazyUtilitiesMod.LOGGER.error("[LZM: Epic Fight] Error cerrando FileSystem", (Throwable)e);
        }
    }
}

