/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.packers.lecter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import con.sleys.lazyutilities.config.EpicFightModuleConfig;
import con.sleys.lazyutilities.modules.epicfight.LZEpicFightMod;
import con.sleys.lazyutilities.modules.epicfight.packers.lecter.EpicFightAssetsAccessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class EpicFightAssetsRedirector
extends EpicFightAssetsAccessor {
    private final String realNamespace;
    private final File fileRedirected;
    private final String redirectedNamespace;

    public EpicFightAssetsRedirector(File file, Map<String, String> namespaceMap) throws IOException {
        super(file, namespaceMap.keySet().iterator().next());
        this.fileRedirected = file;
        this.realNamespace = namespaceMap.values().iterator().next();
        this.redirectedNamespace = namespaceMap.keySet().iterator().next();
        LZEpicFightMod.LOGGER.debug("[LZM: Epic Fight] Redirecci\u00f3n creada. F\u00edsica: {} -> Virtual: {}", (Object)this.realNamespace, (Object)this.redirectedNamespace);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        String ns = location.m_135827_();
        if (ns.equals(this.redirectedNamespace)) {
            ResourceLocation real = ResourceLocation.fromNamespaceAndPath((String)this.realNamespace, (String)location.m_135815_());
            IoSupplier<InputStream> physicalPath = super.m_214146_(type, location);
            if (physicalPath != null) {
                return physicalPath;
            }
            IoSupplier<InputStream> virtualPath = super.m_214146_(type, real);
            if (virtualPath != null) {
                return virtualPath;
            }
            return null;
        }
        return super.m_214146_(type, location);
    }

    @Override
    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput output) {
        if (namespace.equals(this.redirectedNamespace)) {
            super.m_8031_(type, this.realNamespace, prefix, (resLoc, supplier) -> {
                ResourceLocation redirectedLoc = ResourceLocation.fromNamespaceAndPath((String)this.redirectedNamespace, (String)resLoc.m_135815_());
                if (EpicFightModuleConfig.isDepurateRedirector()) {
                    LZEpicFightMod.LOGGER.debug("[LZM: Epic Fight] Redireccionando. Ubicaci\u00f3n f\u00edsica: {} Ubicaci\u00f3n virtual: {}", resLoc, (Object)redirectedLoc);
                }
                output.accept((Object)redirectedLoc, supplier);
            });
        } else {
            super.m_8031_(type, namespace, prefix, output);
        }
    }

    @Override
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        if (!"pack".equals(deserializer.m_7991_())) {
            return null;
        }
        JsonObject fallbackPack = new JsonObject();
        fallbackPack.addProperty("pack_format", (Number)15);
        JsonObject descObj = new JsonObject();
        descObj.addProperty("text", "Redirected From -> " + this.fileRedirected.getName());
        descObj.addProperty("color", "blue");
        fallbackPack.add("description", (JsonElement)descObj);
        return (T)deserializer.m_6322_(fallbackPack);
    }

    @Override
    public Set<String> m_5698_(PackType type) {
        HashSet<String> namespaces = new HashSet<String>(super.m_5698_(type));
        namespaces.add(this.redirectedNamespace);
        return namespaces;
    }
}

