/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.packers.register;

import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.modules.epicfight.packers.lecter.EpicFightAssetsAccessor;
import con.sleys.lazyutilities.modules.epicfight.packers.lecter.EpicFightAssetsRedirector;
import con.sleys.lazyutilities.utilities.FileReadUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class EpicFightAssetsAccessorFinder {
    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER ? event.getPackType() != PackType.SERVER_DATA : event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        File folder = FMLPaths.GAMEDIR.get().resolve("lazy_utilities/epicfight").toFile();
        if (!folder.exists() || !folder.isDirectory()) {
            LazyUtilitiesMod.LOGGER.warn("[LZM: Epic Fight] Directorio no encontrado: {}", (Object)folder.getAbsolutePath());
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            LazyUtilitiesMod.LOGGER.error("[LZM: Epic Fight] Error al listar archivos en {}", (Object)folder.getAbsolutePath());
            return;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            String fileModId = FileReadUtilities.extractFileModId(file);
            if (fileModId == null) {
                LazyUtilitiesMod.LOGGER.warn("[LZM: Epic Fight] No se pudo extraer DomainSpace de: {}", (Object)file.getName());
                continue;
            }
            LazyUtilitiesMod.LOGGER.debug("[LZM: Epic Fight] El dominio del archivo: {} es {}", (Object)file.getName(), (Object)fileModId);
            try {
                Pack pack;
                Pack.ResourcesSupplier supplier;
                String packName = FileReadUtilities.processFileName(file);
                if (file.getName().endsWith(".zip")) {
                    supplier = EpicFightAssetsAccessorFinder.finderEpicFightEventType(file, fileModId, FinderMethod.REDIRECT);
                    pack = Pack.m_245429_((String)("external:" + file.getName()), (Component)Component.m_237113_((String)packName).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD}), (boolean)true, (Pack.ResourcesSupplier)supplier, (PackType)event.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    if (pack == null) continue;
                    event.addRepositorySource(c -> c.accept(pack));
                    LazyUtilitiesMod.LOGGER.info("[LZM: Epic Fight] Paquete redireccionado exitosamente: {}", (Object)file.getName());
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                supplier = EpicFightAssetsAccessorFinder.finderEpicFightEventType(file, fileModId, FinderMethod.REGISTER);
                pack = Pack.m_245429_((String)("external:" + file.getName()), (Component)Component.m_237113_((String)packName).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}), (boolean)true, (Pack.ResourcesSupplier)supplier, (PackType)event.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                if (pack == null) continue;
                event.addRepositorySource(c -> c.accept(pack));
                LazyUtilitiesMod.LOGGER.info("[LZM: Epic Fight] Paquete registrado exitosamente: {}", (Object)file.getName());
            }
            catch (Exception e) {
                LazyUtilitiesMod.LOGGER.error("[LZM: Epic Fight] Fallo al registrar datos: {}", (Object)file.getName(), (Object)e);
            }
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Pack.ResourcesSupplier finderEpicFightEventType(File file, String fileModId, FinderMethod type) {
        if (type == FinderMethod.REDIRECT) {
            Map<CallSite, String> redirects = Map.of("redirected_" + fileModId, fileModId);
            return path -> {
                try {
                    return new EpicFightAssetsRedirector(file, redirects);
                }
                catch (IOException e) {
                    throw new RuntimeException("[LZM: Epic Fight] Fallo el intento de redireccionar los activos para: " + file.getName(), e);
                }
            };
        }
        return path -> {
            try {
                return new EpicFightAssetsAccessor(file, fileModId);
            }
            catch (IOException e) {
                throw new RuntimeException("[LZM: Epic Fight] Fallo el intento de registrar los activos para: " + file.getName(), e);
            }
        };
    }

    public static enum FinderMethod {
        REDIRECT,
        REGISTER;

    }
}

