/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.registry;

import con.sleys.lazyutilities.config.LazyUtilitiesConfigCommon;
import con.sleys.lazyutilities.modules.epicfight.LZEpicFightMod;
import con.sleys.lazyutilities.modules.epicfight.anotations.GlobalSkill;
import con.sleys.lazyutilities.modules.epicfight.forgeevents.GlobalSkillEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GlobalSkillDispatcher {
    private static final Map<Object, Set<Method>> registeredMethods = new HashMap<Object, Set<Method>>();
    private static final Object masterListener = new MasterListener();

    public static void register(Object target) {
        registeredMethods.put(target, new HashSet());
        for (Method method : target.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(GlobalSkill.class)) continue;
            if (method.getParameterCount() != 1) {
                LZEpicFightMod.LOGGER.warn("M\u00e9todo {} ignorado: debe tener exactamente un par\u00e1metro", (Object)method.getName());
                continue;
            }
            Class<?> paramType = method.getParameterTypes()[0];
            if (!GlobalSkillDispatcher.isValidEventType(paramType)) {
                LZEpicFightMod.LOGGER.warn("M\u00e9todo {} ignorado: par\u00e1metro debe ser ActivationEvent, DeactivationEvent o ContinuousEvent", (Object)method.getName());
                continue;
            }
            GlobalSkill annotationKeys = method.getAnnotation(GlobalSkill.class);
            String modId = annotationKeys.modId();
            String skillKey = annotationKeys.keySkill();
            GlobalSkillEvent.safeRegister(modId, skillKey);
            registeredMethods.get(target).add(method);
        }
    }

    public static void unregister(Object target) {
        registeredMethods.remove(target);
    }

    private static boolean isValidEventType(Class<?> type) {
        return GlobalSkillEvent.ActivationEvent.class.equals(type) || GlobalSkillEvent.DeactivationEvent.class.equals(type) || GlobalSkillEvent.ContinuousEvent.class.equals(type);
    }

    static {
        MinecraftForge.EVENT_BUS.register(masterListener);
    }

    private static class MasterListener {
        private MasterListener() {
        }

        @SubscribeEvent
        public void onActivation(GlobalSkillEvent.ActivationEvent event) {
            this.dispatchEvent(event);
        }

        @SubscribeEvent
        public void onDeactivation(GlobalSkillEvent.DeactivationEvent event) {
            this.dispatchEvent(event);
        }

        @SubscribeEvent
        public void onContinuous(GlobalSkillEvent.ContinuousEvent event) {
            this.dispatchEvent(event);
        }

        private void dispatchEvent(Event event) {
            String passiveKey = this.getPassiveKeyFromEvent(event);
            for (Map.Entry<Object, Set<Method>> entry : registeredMethods.entrySet()) {
                for (Method method : entry.getValue()) {
                    GlobalSkill annotation = method.getAnnotation(GlobalSkill.class);
                    String expectedKey = annotation.modId() + ":" + annotation.keySkill();
                    if (!expectedKey.equals(passiveKey) || !method.getParameterTypes()[0].isInstance(event)) continue;
                    if (LazyUtilitiesConfigCommon.getErrorHandlerEpicFight() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
                        try {
                            method.setAccessible(true);
                            method.invoke(entry.getKey(), event);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        method.setAccessible(true);
                        method.invoke(entry.getKey(), event);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Ha ocurrido un error dada su configuraci\u00f3n, se ha optado por finalizar la instancia, su error es: ", e);
                    }
                }
            }
        }

        private String getPassiveKeyFromEvent(Event event) {
            if (event instanceof GlobalSkillEvent.ActivationEvent) {
                return ((GlobalSkillEvent.ActivationEvent)event).getPassiveKey();
            }
            if (event instanceof GlobalSkillEvent.DeactivationEvent) {
                return ((GlobalSkillEvent.DeactivationEvent)event).getPassiveKey();
            }
            if (event instanceof GlobalSkillEvent.ContinuousEvent) {
                return ((GlobalSkillEvent.ContinuousEvent)event).getPassiveKey();
            }
            return null;
        }
    }
}

