/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.runner.reader;

import con.sleys.lazyutilities.modules.epicfight.LZEpicFightMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class LegacyRunnerBase {
    protected static final Map<String, String> KNOWN_ADDONS = new HashMap<String, String>();
    public static List<String> Addons_Loader_Raw = new ArrayList<String>();

    public void processRequest(String sourceModId, String targetModId, File addonsDir) {
        File[] files;
        ArrayList<String> knownAddons = new ArrayList<String>();
        ArrayList<String> detectedAddons = new ArrayList<String>();
        ArrayList<String> invalidAddons = new ArrayList<String>();
        HashMap<String, File> modIdToFileMap = new HashMap<String, File>();
        if (addonsDir.exists() && addonsDir.isDirectory() && (files = addonsDir.listFiles()) != null) {
            for (File file : files) {
                String modId;
                if (!file.isFile()) continue;
                String fileName = file.getName();
                if (fileName.endsWith(".zip")) {
                    if (!this.isValidAddon(file)) {
                        invalidAddons.add(fileName);
                        continue;
                    }
                    modId = this.extractModIdFromAssets(file);
                    if (modId == null) continue;
                    if (modIdToFileMap.containsKey(modId)) {
                        LZEpicFightMod.LOGGER.error("[LZM: Epic Fight] NameSpace Duplicado en el archivo .zip: {}", (Object)modId);
                        break;
                    }
                    modIdToFileMap.put(modId, file);
                    this.registerAddon(modId, file, knownAddons, detectedAddons, sourceModId, targetModId);
                    continue;
                }
                if (!fileName.endsWith(".jar")) continue;
                modId = this.extractModIdFromTOML(file);
                if (modId != null) {
                    List<String> restrictedMods = Arrays.asList("epicfight", "wom", "battlearts_api");
                    if (restrictedMods.contains(modId)) {
                        File renamedFile = new File(file.getParent(), fileName + ".DISABLE");
                        if (file.renameTo(renamedFile)) {
                            LZEpicFightMod.LOGGER.info("[LZM: Epic Fight] El archivo {} ha sido deshabilitado", (Object)renamedFile.getName());
                            continue;
                        }
                        LZEpicFightMod.LOGGER.error("[LZM: Epic Fight] El intento por deshabilitar {} ha fallado", (Object)renamedFile.getName());
                        continue;
                    }
                    if (modIdToFileMap.containsKey(modId)) {
                        LZEpicFightMod.LOGGER.error("[LZM: Epic Fight] NameSpace Duplicado en el archivo .jar: {}", (Object)modId);
                        break;
                    }
                    modIdToFileMap.put(modId, file);
                    this.registerAddon(modId, file, knownAddons, detectedAddons, sourceModId, targetModId);
                    continue;
                }
                invalidAddons.add(fileName);
            }
        }
        List<String> disabledAddons = this.getDisabledAddons(addonsDir);
        this.onProcessComplete(knownAddons, detectedAddons, invalidAddons, disabledAddons);
    }

    protected abstract void onProcessComplete(List<String> var1, List<String> var2, List<String> var3, List<String> var4);

    private void registerAddon(String modId, File file, List<String> knownAddons, List<String> detectedAddons, String sourceModId, String targetModId) {
        if (KNOWN_ADDONS.containsKey(modId)) {
            knownAddons.add(KNOWN_ADDONS.get(modId));
        } else {
            detectedAddons.add(modId);
        }
        if (!Addons_Loader_Raw.contains(modId)) {
            Addons_Loader_Raw.add(modId);
        }
    }

    private List<String> getDisabledAddons(File addonsDir) {
        File[] files;
        ArrayList<String> disabledAddons = new ArrayList<String>();
        if (addonsDir.exists() && addonsDir.isDirectory() && (files = addonsDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".DISABLE")) continue;
                String formattedName = file.getName().replace(".DISABLE", "");
                disabledAddons.add(formattedName);
            }
        }
        return disabledAddons;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidAddon(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while (!(entry = entries.nextElement()).getName().startsWith("assets/") || !entry.getName().contains("/animmodels/animations/biped/") || !entry.isDirectory());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String extractModIdFromTOML(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry = zipFile.getEntry("META-INF/mods.toml");
            if (entry == null) return null;
            try (InputStream stream = zipFile.getInputStream(entry);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String modId;
                String line;
                do {
                    if ((line = reader.readLine()) == null) return null;
                } while (!line.trim().startsWith("modId=") || (modId = line.split("=")[1].split("#")[0].replace("\"", "").trim()).isEmpty());
                String string = modId;
                return string;
            }
        }
        catch (IOException e) {
            LZEpicFightMod.LOGGER.error("[LZM: Epic Fight] Error al intentar leer el archivo mods.toml: {}", (Object)e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String extractModIdFromAssets(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            String[] parts;
            ZipEntry zipEntry;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            Iterator<? extends ZipEntry> iterator = Collections.list(entries).iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!(zipEntry = iterator.next()).getName().startsWith("assets/") || !zipEntry.isDirectory() || (parts = zipEntry.getName().split("/")).length <= 1);
            String string = parts[1];
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        KNOWN_ADDONS.put("epicacg", "Epic Fight - ACG By dfdyz | Tairitsu");
        KNOWN_ADDONS.put("epicfight", "Epic Fight - Animations By Asanginxst");
        KNOWN_ADDONS.put("yamatomoveset", "Epic Fight - Yamato Moveset By Namelesslk");
        KNOWN_ADDONS.put("efdg", "Epic Fight - Dual Greatsword By Reascer");
        KNOWN_ADDONS.put("epicsanji", "Epic Fight - Epic Sanji By Reascer");
        KNOWN_ADDONS.put("infernal", "Epic Fight - Infernal Gainer By Reascer");
    }
}

