/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.runner.register;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import con.sleys.lazyutilities.modules.epicfight.LZEpicFightMod;
import con.sleys.lazyutilities.modules.epicfight.runner.register.RequestRecordsManager;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestRecordStorage {
    private static final Logger LOGGER = LogManager.getLogger(LZEpicFightMod.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path SAVE_PATH = Paths.get("lazy_utilities/RequestKeys.json", new String[0]);
    public static boolean ChangesMade = false;
    public static boolean CounterLoop = false;

    public static void loadRequests() {
        if (!Files.exists(SAVE_PATH, new LinkOption[0])) {
            ChangesMade = true;
            return;
        }
        try (FileReader reader = new FileReader(SAVE_PATH.toFile());){
            RequestData requestData = (RequestData)GSON.fromJson((Reader)reader, RequestData.class);
            if (requestData != null && requestData.requests != null) {
                if (!requestData.requests.equals(RequestRecordsManager.getRequestedMods())) {
                    ChangesMade = true;
                } else {
                    ChangesMade = false;
                    CounterLoop = true;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("[LZM: Epic Fight] Error al leer el archivo JSON: ", (Throwable)e);
        }
    }

    public static void saveRequests() {
        if (!ChangesMade) {
            return;
        }
        try {
            Files.createDirectories(SAVE_PATH.getParent(), new FileAttribute[0]);
            HashMap<String, Map<String, String>> saveData = new HashMap<String, Map<String, String>>();
            saveData.put("requests", RequestRecordsManager.getRequestedMods());
            try (FileWriter writer = new FileWriter(SAVE_PATH.toFile());){
                GSON.toJson(saveData, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("[LZM: Epic Fight] Error al guardar el archivo JSON: ", (Throwable)e);
        }
    }

    public static class RequestData {
        public Map<String, String> requests;
    }
}

