/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CTSMessageApplyCooldown {
    private final int slotOrdinal;
    private final int cooldownTicks;

    public CTSMessageApplyCooldown(EquipmentSlot slot, int cooldownTicks) {
        this.slotOrdinal = slot.ordinal();
        this.cooldownTicks = cooldownTicks;
    }

    public CTSMessageApplyCooldown(FriendlyByteBuf buf) {
        this.slotOrdinal = buf.readInt();
        this.cooldownTicks = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slotOrdinal);
        buf.writeInt(this.cooldownTicks);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            EquipmentSlot slot;
            ItemStack stack;
            ServerPlayer player = context.getSender();
            if (player != null && !(stack = player.m_6844_(slot = EquipmentSlot.values()[this.slotOrdinal])).m_41619_()) {
                player.m_36335_().m_41524_(stack.m_41720_(), this.cooldownTicks);
            }
        });
        context.setPacketHandled(true);
    }
}

