/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.network;

import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.network.STCFocalTagSyncPacketClient;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record STCFocalTagSyncPacket(String tagKey, Tag tagData) {
    public static void encode(STCFocalTagSyncPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.tagKey);
        buf.writeByte((int)STCFocalTagSyncPacket.getTagTypeId(msg.tagData));
        if (msg.tagData == null) {
            throw new IllegalArgumentException("No se puede ejecutar una sincronizaci\u00f3n 'Server To Client' si el tag es nulo para la clave: " + msg.tagKey);
        }
        switch (msg.tagData.m_7060_()) {
            case 1: {
                buf.writeByte((int)((ByteTag)msg.tagData).m_7063_());
                break;
            }
            case 3: {
                buf.writeInt(((IntTag)msg.tagData).m_7047_());
                break;
            }
            case 4: {
                buf.writeLong(((LongTag)msg.tagData).m_7046_());
                break;
            }
            case 5: {
                buf.writeFloat(((FloatTag)msg.tagData).m_7057_());
                break;
            }
            case 6: {
                buf.writeDouble(((DoubleTag)msg.tagData).m_7061_());
                break;
            }
            case 8: {
                buf.m_130070_(((StringTag)msg.tagData).m_7916_());
                break;
            }
            case 10: {
                buf.m_130079_((CompoundTag)msg.tagData);
                break;
            }
            default: {
                throw new IllegalArgumentException("El tipo de etiqueta solicitada para sincronizaci\u00f3n 'Server To Client no es v\u00e1lida...");
            }
        }
    }

    public static STCFocalTagSyncPacket decode(FriendlyByteBuf buf) {
        String key = buf.m_130277_();
        byte typeId = buf.readByte();
        CompoundTag data = switch (typeId) {
            case 1 -> ByteTag.m_128266_((byte)buf.readByte());
            case 3 -> IntTag.m_128679_((int)buf.readInt());
            case 4 -> LongTag.m_128882_((long)buf.readLong());
            case 5 -> FloatTag.m_128566_((float)buf.readFloat());
            case 6 -> DoubleTag.m_128500_((double)buf.readDouble());
            case 8 -> StringTag.m_129297_((String)buf.m_130277_());
            case 10 -> buf.m_130260_();
            default -> throw new IllegalArgumentException("Etiqueta solicitada para sincronizaci\u00f3n 'Server To Client desconocida...");
        };
        return new STCFocalTagSyncPacket(key, (Tag)data);
    }

    private static byte getTagTypeId(Tag tag) {
        return tag != null ? tag.m_7060_() : (byte)0;
    }

    public static void handle(STCFocalTagSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> STCFocalTagSyncPacketClient.handleFocalTagSync(msg.tagKey, msg.tagData));
        ctx.get().setPacketHandled(true);
    }

    public static void sendTo(ServerPlayer player, String tagKey, Tag tagData) {
        LazyUtilitiesMod.PACKET_HANDLER.sendTo((Object)new STCFocalTagSyncPacket(tagKey, tagData), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

