/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.packers.register;

import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.packers.lecter.LazyUtilitiesDataAccessor;
import con.sleys.lazyutilities.utilities.FileReadUtilities;
import java.io.File;
import java.io.IOException;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="lazy_utilities", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LazyUtilitiesDataAccessorFinder {
    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.SERVER_DATA) {
            return;
        }
        File folder = FMLPaths.GAMEDIR.get().resolve("lazy_utilities/global/datapacks").toFile();
        if (!folder.exists() || !folder.isDirectory()) {
            LazyUtilitiesMod.LOGGER.warn("[Lazy Utilities -/- Data Finder] Directorio no encontrado: {}", (Object)folder.getAbsolutePath());
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            LazyUtilitiesMod.LOGGER.error("[Lazy Utilities -/- Data Finder] Error al listar archivos en {}", (Object)folder.getAbsolutePath());
            return;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            try {
                String packName = FileReadUtilities.processFileName(file);
                Pack pack = Pack.m_245429_((String)("\u00a76external:" + file.getName()), (Component)Component.m_237113_((String)packName).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), (boolean)true, (Pack.ResourcesSupplier)LazyUtilitiesDataAccessorFinder.finderLazyUtilitiesDataEventType(file), (PackType)event.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                if (pack == null) continue;
                event.addRepositorySource(c -> c.accept(pack));
                LazyUtilitiesMod.LOGGER.info("[Lazy Utilities -/- Data Finder] Paquete registrado exitosamente: {}", (Object)file.getName());
            }
            catch (Exception e) {
                LazyUtilitiesMod.LOGGER.error("[Lazy Utilities -/- Data Finder] Fallo al registrar datos: {}", (Object)file.getName(), (Object)e);
            }
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Pack.ResourcesSupplier finderLazyUtilitiesDataEventType(File file) {
        return path -> {
            try {
                return new LazyUtilitiesDataAccessor(file);
            }
            catch (IOException e) {
                throw new RuntimeException("[Lazy Utilities -/- Data Finder] Fallo el intento de registrar los datos para: " + file.getName(), e);
            }
        };
    }
}

