/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.utilities;

import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class ScreenUtilities {
    public static Vec3 projectToScreen(Vec3 worldPos) {
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        Matrix4f viewMatrix = ScreenUtilities.getViewMatrix(camera);
        Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4f viewProj = new Matrix4f((Matrix4fc)projectionMatrix).mul((Matrix4fc)viewMatrix);
        Vector4f pos = new Vector4f((float)worldPos.f_82479_, (float)worldPos.f_82480_, (float)worldPos.f_82481_, 1.0f);
        pos.mul((Matrix4fc)viewProj);
        if (pos.w != 0.0f) {
            pos.div(pos.w);
        }
        float x = pos.x * 0.5f + 0.5f;
        float y = 1.0f - (pos.y * 0.5f + 0.5f);
        return new Vec3((double)x, (double)y, (double)pos.z);
    }

    public static Vec2 projectToScreenNormalized(Vec3 worldPos) {
        Vec3 screenCoords = ScreenUtilities.projectToScreen(worldPos);
        Minecraft mc = Minecraft.m_91087_();
        float normalizedX = (float)(screenCoords.f_82479_ / (double)mc.m_91268_().m_85441_());
        float normalizedY = (float)(screenCoords.f_82480_ / (double)mc.m_91268_().m_85442_());
        return new Vec2(normalizedX, normalizedY);
    }

    public static Matrix4f getViewMatrix(Camera camera) {
        Vec3 camPos = camera.m_90583_();
        float pitch = camera.m_90589_();
        float yaw = camera.m_90590_();
        Matrix4f viewMatrix = new Matrix4f().identity();
        viewMatrix.rotateY((float)Math.toRadians(-yaw));
        viewMatrix.rotateX((float)Math.toRadians(pitch));
        viewMatrix.translate((float)(-camPos.f_82479_), (float)(-camPos.f_82480_), (float)(-camPos.f_82481_));
        return viewMatrix;
    }

    public static void debugProjection(Vec3 worldPos) {
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        System.out.println("=== DEBUG Projection ===");
        System.out.println("Tipo de perspectiva (camara): " + String.valueOf(Perspective.current()));
        System.out.println("World Pos: " + String.valueOf(worldPos));
        System.out.println("Camera Pos: " + String.valueOf(camera.m_90583_()));
        System.out.println("Camera Looking at: " + String.valueOf(camera.m_253058_()));
        Vec3 toPoint = worldPos.m_82546_(camera.m_90583_());
        System.out.println("Vector to point: " + String.valueOf(toPoint));
        System.out.println("Distance to point: " + toPoint.m_82553_());
        Vec3 s = ScreenUtilities.projectToScreen(worldPos);
        Vec2 s1 = ScreenUtilities.projectToScreenNormalized(worldPos);
        System.out.println("Resultado Final, X: " + s.f_82479_ + " Y:" + s.f_82480_ + " S:" + s.f_82481_);
        System.out.println("Resultado Final Normalizado, X: " + s1.f_82470_ + " Y: " + s1.f_82471_);
        System.out.println("=== END DEBUG ===");
    }

    public static void setUniformSafe(EffectInstance effect, String name, float value) {
        if (effect.m_108952_(name) != null) {
            Objects.requireNonNull(effect.m_108952_(name)).m_5985_(value);
        }
    }

    public static void setUniformSafe(EffectInstance effect, String name, int value) {
        if (effect.m_108952_(name) != null) {
            Objects.requireNonNull(effect.m_108952_(name)).m_142617_(value);
        }
    }

    public static void setUniformSafe(EffectInstance effect, String name, float[] values) {
        if (effect.m_108952_(name) != null) {
            Objects.requireNonNull(effect.m_108952_(name)).m_5941_(values);
        }
    }
}

