#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D PrevSampler;
uniform vec2 OutSize;
uniform float Time;
uniform float intensity;
uniform vec3 flashColor;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 base = texture(DiffuseSampler, texCoord);

    // Efecto de "flash"
    vec3 boosted = base.rgb * (1.0 + intensity * 2.0);
    boosted = mix(boosted, flashColor, intensity * 0.6);

    fragColor = vec4(clamp(boosted, 0.0, 1.0), base.a);
}