#version 150
uniform sampler2D DiffuseSampler;
uniform vec2 ScreenSize;
uniform vec2 FocalUV;
uniform float Radius;
uniform float Feather;
uniform float AmbientBoost;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 color = texture(DiffuseSampler, texCoord);
    float luminance = dot(color.rgb, vec3(0.299, 0.587, 0.114));

    // Mascara Radial
    float dist = distance(texCoord, FocalUV);
    float radialMask = 1.0 - smoothstep(Radius - Feather, Radius + Feather, dist);
    float result = clamp(luminance * radialMask + AmbientBoost * radialMask, 0.0, 1.0);
    fragColor = vec4(result, result, result, result * 0.999);
}
