/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.block;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.init.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class HotelControllerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public HotelControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HotelControllerBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.m_5776_() && placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof HotelControllerBlockEntity) {
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
                controller.setOwner(player.m_20148_(), player.m_7755_().getString());
                if (stack.m_41788_()) {
                    controller.setHotelName(stack.m_41786_().getString());
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be;
        if (!level.m_5776_() && (be = level.m_7702_(pos)) instanceof HotelControllerBlockEntity) {
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (controller.hasManagementAccess(player)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)controller, (BlockPos)pos);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.no_management_access").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!state.m_60713_(newState.m_60734_()) && (be = level.m_7702_(pos)) instanceof HotelControllerBlockEntity) {
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            controller.onRemoved();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.m_5776_()) {
            return HotelControllerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.HOTEL_CONTROLLER.get()), HotelControllerBlockEntity::serverTick);
        }
        return null;
    }
}

