/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.block;

import com.lchotels.blockentity.KeycardDoorBlockEntity;
import com.lchotels.data.HotelData;
import com.lchotels.data.RoomData;
import com.lchotels.init.ModItems;
import com.lchotels.item.OwnerKeycardItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeycardDoorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public KeycardDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HINGE, HALF});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean rightHinge;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        boolean bl = rightHinge = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        if (!open) {
            return switch (direction) {
                case Direction.EAST -> EAST_AABB;
                case Direction.SOUTH -> SOUTH_AABB;
                case Direction.WEST -> WEST_AABB;
                default -> NORTH_AABB;
            };
        }
        return switch (direction) {
            case Direction.EAST -> {
                if (rightHinge) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if (rightHinge) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (rightHinge) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            default -> rightHinge ? WEST_AABB : EAST_AABB;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            Direction facing = context.m_8125_();
            boolean rightHinge = this.getHinge(context);
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(HINGE, (Comparable)(rightHinge ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    private boolean getHinge(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_8125_();
        Direction left = facing.m_122428_();
        BlockPos leftPos = pos.m_121945_(left);
        BlockState leftState = level.m_8055_(leftPos);
        Direction right = facing.m_122427_();
        BlockPos rightPos = pos.m_121945_(right);
        BlockState rightState = level.m_8055_(rightPos);
        int leftWeight = leftState.m_60838_((BlockGetter)level, leftPos) ? -1 : 0;
        int rightWeight = rightState.m_60838_((BlockGetter)level, rightPos) ? -1 : 0;
        return leftWeight < rightWeight;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != half ? (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)neighborState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)neighborState.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)neighborState.m_61143_(HINGE))) : Blocks.f_50016_.m_49966_();
        }
        return half == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos belowPos;
        BlockState belowState;
        DoubleBlockHalf half;
        if (!level.f_46443_ && player.m_7500_() && (half = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.UPPER && (belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60713_((Block)this) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_7731_(belowPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, belowPos, Block.m_49956_((BlockState)belowState));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return new KeycardDoorBlockEntity(pos, state);
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ServerLevel serverLevel;
        HotelData hotelData;
        RoomData room;
        ItemStack heldItem = player.m_21120_(hand);
        BlockPos lowerPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockEntity be = level.m_7702_(lowerPos);
        if (!(be instanceof KeycardDoorBlockEntity)) {
            return InteractionResult.PASS;
        }
        KeycardDoorBlockEntity doorEntity = (KeycardDoorBlockEntity)be;
        if (heldItem.m_150930_((Item)ModItems.OWNER_KEYCARD.get())) {
            return this.handleOwnerKeycardUse(level, pos, state, player, heldItem, doorEntity);
        }
        if (heldItem.m_150930_((Item)ModItems.KEYCARD.get())) {
            return this.handleKeycardUse(level, pos, state, player, heldItem, doorEntity);
        }
        String linkedRoomId = doorEntity.getLinkedRoomId();
        if (linkedRoomId != null && !linkedRoomId.isEmpty() && level instanceof ServerLevel && (room = (hotelData = HotelData.get((Level)(serverLevel = (ServerLevel)level))).getRoom(linkedRoomId)) != null && room.isRented()) {
            if (player.m_20148_().equals(room.getCurrentGuest())) {
                this.toggleDoor(level, pos, state, player);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (!level.m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.access_denied"), true);
            }
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_()) {
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.keycard_required"), true);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult handleOwnerKeycardUse(Level level, BlockPos pos, BlockState state, Player player, ItemStack ownerKeycard, KeycardDoorBlockEntity doorEntity) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos keycardControllerPos = OwnerKeycardItem.getControllerPos(ownerKeycard);
        UUID keycardOwnerId = OwnerKeycardItem.getOwnerId(ownerKeycard);
        if (keycardControllerPos.equals((Object)BlockPos.f_121853_) || keycardOwnerId == null) {
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.invalid_keycard"), true);
            return InteractionResult.FAIL;
        }
        BlockPos doorControllerPos = doorEntity.getLinkedControllerPos();
        if (doorControllerPos.equals((Object)keycardControllerPos)) {
            if (player.m_20148_().equals(keycardOwnerId)) {
                this.toggleDoor(level, pos, state, player);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.not_owner"), true);
            return InteractionResult.FAIL;
        }
        player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.wrong_hotel"), true);
        return InteractionResult.FAIL;
    }

    private InteractionResult handleKeycardUse(Level level, BlockPos pos, BlockState state, Player player, ItemStack keycard, KeycardDoorBlockEntity doorEntity) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        String keycardRoomId = keycard.m_41784_().m_128461_("RoomId");
        String linkedRoomId = doorEntity.getLinkedRoomId();
        if (keycardRoomId.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.invalid_keycard"), true);
            return InteractionResult.FAIL;
        }
        if (keycardRoomId.equals(linkedRoomId)) {
            HotelData hotelData = HotelData.get((Level)((ServerLevel)level));
            RoomData room = hotelData.getRoom(keycardRoomId);
            if (room != null && room.isRented() && room.getCurrentGuest().equals(player.m_20148_())) {
                this.toggleDoor(level, pos, state, player);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.rental_expired"), true);
            return InteractionResult.FAIL;
        }
        player.m_5661_((Component)Component.m_237115_((String)"lchotels.door.wrong_room"), true);
        return InteractionResult.FAIL;
    }

    private void toggleDoor(Level level, BlockPos pos, BlockState state, Player player) {
        boolean nowOpen = (Boolean)state.m_61143_((Property)OPEN) == false;
        BlockPos lowerPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockPos upperPos = lowerPos.m_7494_();
        BlockState lowerState = level.m_8055_(lowerPos);
        BlockState upperState = level.m_8055_(upperPos);
        if (lowerState.m_60713_((Block)this)) {
            level.m_7731_(lowerPos, (BlockState)lowerState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(nowOpen)), 10);
        }
        if (upperState.m_60713_((Block)this)) {
            level.m_7731_(upperPos, (BlockState)upperState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(nowOpen)), 10);
        }
        level.m_5594_(null, pos, nowOpen ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
        level.m_142346_((Entity)player, nowOpen ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
    }
}

