/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.blockentity;

import com.lchotels.config.LCHotelsConfig;
import com.lchotels.data.AmenityType;
import com.lchotels.data.HotelData;
import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import com.lchotels.init.ModBlockEntities;
import com.lchotels.menu.HotelControllerMenu;
import com.lchotels.util.MoneyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class HotelControllerBlockEntity
extends BlockEntity
implements MenuProvider {
    private UUID hotelId;
    private String hotelName = "New Hotel";
    private UUID ownerId;
    private String ownerName = "";
    private Map<String, RoomData> rooms = new HashMap<String, RoomData>();
    private Set<BlockPos> linkedDoors = new HashSet<BlockPos>();
    private Set<BlockPos> linkedFrontDesks = new HashSet<BlockPos>();
    private long storedMoney = 0L;
    private int tickCounter = 0;
    private Map<UUID, String> staffMembers = new HashMap<UUID, String>();
    private Map<UUID, String> coOwners = new HashMap<UUID, String>();
    private Map<RoomType, Set<AmenityType>> roomTypeAmenities = new HashMap<RoomType, Set<AmenityType>>();
    private Set<String> warnedRooms = new HashSet<String>();

    public HotelControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HOTEL_CONTROLLER.get(), pos, state);
        this.initializeDefaultAmenities();
    }

    private void initializeDefaultAmenities() {
        for (RoomType type : RoomType.values()) {
            this.roomTypeAmenities.put(type, this.getDefaultAmenitiesForType(type));
        }
    }

    private Set<AmenityType> getDefaultAmenitiesForType(RoomType type) {
        HashSet<AmenityType> amenities = new HashSet<AmenityType>();
        switch (type) {
            case PENTHOUSE: {
                amenities.addAll(Arrays.asList(AmenityType.values()));
                break;
            }
            case SUITE: {
                amenities.add(AmenityType.POOL);
                amenities.add(AmenityType.GYM);
                amenities.add(AmenityType.SPA);
                amenities.add(AmenityType.RESTAURANT);
                amenities.add(AmenityType.LOUNGE);
                amenities.add(AmenityType.PARKING);
                amenities.add(AmenityType.ROOFTOP);
                break;
            }
            case DELUXE: {
                amenities.add(AmenityType.POOL);
                amenities.add(AmenityType.GYM);
                amenities.add(AmenityType.RESTAURANT);
                amenities.add(AmenityType.PARKING);
                break;
            }
            case STANDARD: {
                amenities.add(AmenityType.POOL);
                amenities.add(AmenityType.GYM);
                amenities.add(AmenityType.PARKING);
                break;
            }
            case CONFERENCE_SMALL: 
            case CONFERENCE_MEDIUM: 
            case CONFERENCE_LARGE: 
            case BALLROOM: {
                amenities.add(AmenityType.PARKING);
                amenities.add(AmenityType.RESTAURANT);
            }
        }
        return amenities;
    }

    public Set<AmenityType> getAmenitiesForRoomType(RoomType type) {
        return new HashSet<AmenityType>(this.roomTypeAmenities.getOrDefault((Object)type, new HashSet()));
    }

    public void setAmenitiesForRoomType(RoomType type, Set<AmenityType> amenities) {
        this.roomTypeAmenities.put(type, new HashSet<AmenityType>(amenities));
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void toggleAmenityForRoomType(RoomType type, AmenityType amenity) {
        Set amenities = this.roomTypeAmenities.computeIfAbsent(type, k -> new HashSet());
        if (amenities.contains((Object)amenity)) {
            amenities.remove((Object)amenity);
        } else {
            amenities.add(amenity);
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean roomTypeHasAmenity(RoomType type, AmenityType amenity) {
        Set<AmenityType> amenities = this.roomTypeAmenities.get((Object)type);
        return amenities != null && amenities.contains((Object)amenity);
    }

    public void setOwner(UUID ownerId, String ownerName) {
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hotelId == null) {
                HotelData hotelData = HotelData.get((Level)serverLevel);
                this.hotelId = hotelData.createHotel(this.hotelName, ownerId, ownerName, this.f_58858_);
            }
        }
        this.m_6596_();
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean isOwner(Player player) {
        return this.ownerId != null && this.ownerId.equals(player.m_20148_());
    }

    public boolean isCoOwner(Player player) {
        return this.coOwners.containsKey(player.m_20148_());
    }

    public boolean isStaff(Player player) {
        return this.staffMembers.containsKey(player.m_20148_());
    }

    public boolean hasManagementAccess(Player player) {
        return this.isOwner(player) || this.isCoOwner(player) || this.isStaff(player);
    }

    public boolean canWithdrawMoney(Player player) {
        return this.isOwner(player) || this.isCoOwner(player);
    }

    public boolean canManageStaff(Player player) {
        return this.isOwner(player);
    }

    public boolean canConfigureAmenities(Player player) {
        return this.isOwner(player) || this.isCoOwner(player);
    }

    public void addStaffMember(UUID playerId, String playerName) {
        this.staffMembers.put(playerId, playerName);
        this.m_6596_();
    }

    public void removeStaffMember(UUID playerId) {
        this.staffMembers.remove(playerId);
        this.m_6596_();
    }

    public Map<UUID, String> getStaffMembers() {
        return new HashMap<UUID, String>(this.staffMembers);
    }

    public void addCoOwner(UUID playerId, String playerName) {
        this.coOwners.put(playerId, playerName);
        this.m_6596_();
    }

    public void removeCoOwner(UUID playerId) {
        this.coOwners.remove(playerId);
        this.m_6596_();
    }

    public Map<UUID, String> getCoOwners() {
        return new HashMap<UUID, String>(this.coOwners);
    }

    public UUID getHotelId() {
        return this.hotelId;
    }

    public String getHotelName() {
        return this.hotelName;
    }

    public void setHotelName(String name) {
        this.hotelName = name;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            HotelData hotelData;
            HotelData.HotelInfo hotel;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hotelId != null && (hotel = (hotelData = HotelData.get((Level)serverLevel)).getHotel(this.hotelId)) != null) {
                hotel.hotelName = name;
            }
        }
        this.m_6596_();
    }

    public RoomData createRoom(String roomNumber, RoomType type, long pricePerDay) {
        Level level;
        if (this.rooms.size() >= (Integer)LCHotelsConfig.MAX_ROOMS_PER_HOTEL.get()) {
            return null;
        }
        long maxPrice = (Long)LCHotelsConfig.MAX_ROOM_PRICE.get();
        if (pricePerDay > maxPrice) {
            pricePerDay = maxPrice;
        }
        if ((level = this.f_58857_) instanceof ServerLevel) {
            HotelData hotelData;
            RoomData room;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hotelId != null && (room = (hotelData = HotelData.get((Level)serverLevel)).createRoom(this.hotelId, roomNumber, type, pricePerDay)) != null) {
                this.rooms.put(room.getRoomId(), room);
                room.setControllerPos(this.f_58858_);
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                return room;
            }
        }
        return null;
    }

    public void removeRoom(String roomId) {
        this.rooms.remove(roomId);
        this.warnedRooms.remove(roomId);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hotelId != null) {
                HotelData hotelData = HotelData.get((Level)serverLevel);
                hotelData.removeRoom(this.hotelId, roomId);
            }
        }
        this.m_6596_();
    }

    public RoomData getRoom(String roomId) {
        return this.rooms.get(roomId);
    }

    public Collection<RoomData> getAllRooms() {
        return this.rooms.values();
    }

    public List<RoomData> getAvailableRooms() {
        ArrayList<RoomData> available = new ArrayList<RoomData>();
        for (RoomData room : this.rooms.values()) {
            if (!room.isAvailable()) continue;
            available.add(room);
        }
        return available;
    }

    public List<RoomData> getRoomsByType(RoomType type) {
        ArrayList<RoomData> result = new ArrayList<RoomData>();
        for (RoomData room : this.rooms.values()) {
            if (room.getRoomType() != type) continue;
            result.add(room);
        }
        return result;
    }

    public void linkDoor(BlockPos doorPos) {
        this.linkedDoors.add(doorPos);
        this.m_6596_();
    }

    public void unlinkDoor(BlockPos doorPos) {
        this.linkedDoors.remove(doorPos);
        this.m_6596_();
    }

    public Set<BlockPos> getLinkedDoors() {
        return this.linkedDoors;
    }

    public boolean isDoorInRange(BlockPos doorPos) {
        int maxRange = (Integer)LCHotelsConfig.KEYCARD_DOOR_RANGE.get();
        return doorPos.m_123314_((Vec3i)this.f_58858_, (double)maxRange);
    }

    public void linkFrontDesk(BlockPos deskPos) {
        this.linkedFrontDesks.add(deskPos);
        this.m_6596_();
    }

    public void unlinkFrontDesk(BlockPos deskPos) {
        this.linkedFrontDesks.remove(deskPos);
        this.m_6596_();
    }

    public Set<BlockPos> getLinkedFrontDesks() {
        return this.linkedFrontDesks;
    }

    public long getStoredMoney() {
        return this.storedMoney;
    }

    public void addMoney(long amount) {
        this.storedMoney += amount;
        this.m_6596_();
    }

    public long withdrawMoney(long amount) {
        long withdrawn = Math.min(amount, this.storedMoney);
        this.storedMoney -= withdrawn;
        this.m_6596_();
        return withdrawn;
    }

    public void withdrawAllMoney(Player player) {
        if (this.storedMoney > 0L && this.canWithdrawMoney(player)) {
            MoneyUtil.giveToPlayer(player, this.storedMoney);
            this.storedMoney = 0L;
            this.m_6596_();
        }
    }

    public boolean processRental(String roomId, UUID guestId, String guestName, int days, long paymentAmount) {
        ServerLevel serverLevel;
        HotelData hotelData;
        RoomData room = this.rooms.get(roomId);
        if (room == null || !room.isAvailable()) {
            return false;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (hotelData = HotelData.get((Level)(serverLevel = (ServerLevel)level))).rentRoom(roomId, guestId, guestName, days, this.f_58857_)) {
            int ticksPerDay = (Integer)LCHotelsConfig.TICKS_PER_RENTAL_DAY.get();
            room.rentRoomWithCustomDay(guestId, guestName, days, this.f_58857_, ticksPerDay);
            this.addMoney(paymentAmount);
            this.warnedRooms.remove(roomId);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean processRental(String roomId, UUID guestId, String guestName, int days) {
        return this.processRental(roomId, guestId, guestName, days, 0L);
    }

    public long processCheckout(String roomId, boolean earlyCheckout) {
        RoomData room = this.rooms.get(roomId);
        if (room == null || !room.isRented()) {
            return 0L;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            HotelData hotelData = HotelData.get((Level)serverLevel);
            long refund = hotelData.checkOutRoom(roomId, this.f_58857_, earlyCheckout);
            room.checkOut();
            this.warnedRooms.remove(roomId);
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            return refund;
        }
        return 0L;
    }

    public void onRemoved() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hotelId != null) {
                HotelData hotelData = HotelData.get((Level)serverLevel);
                hotelData.removeHotel(this.hotelId);
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HotelControllerBlockEntity be) {
        ++be.tickCounter;
        int checkInterval = (Integer)LCHotelsConfig.EXPIRATION_CHECK_INTERVAL.get();
        if (be.tickCounter >= checkInterval) {
            be.tickCounter = 0;
            be.checkRentalStatus();
        }
    }

    private void checkRentalStatus() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean needsSync = false;
        ArrayList<RoomData> expiredRooms = new ArrayList<RoomData>();
        int warningTicks = (Integer)LCHotelsConfig.EXPIRATION_WARNING_TICKS.get();
        for (RoomData room : this.rooms.values()) {
            long remainingTicks;
            if (!room.isRented()) continue;
            UUID guestId = room.getCurrentGuest();
            ServerPlayer guest = serverLevel.m_7654_().m_6846_().m_11259_(guestId);
            if (room.isRentalExpired(this.f_58857_)) {
                ServerPlayer owner;
                expiredRooms.add(room);
                if (guest != null) {
                    guest.m_5661_((Component)Component.m_237110_((String)"lchotels.rental.expired", (Object[])new Object[]{room.getRoomName(), this.hotelName}).m_130940_(ChatFormatting.RED), false);
                }
                if ((owner = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerId)) == null) continue;
                owner.m_5661_((Component)Component.m_237110_((String)"lchotels.rental.expired_owner", (Object[])new Object[]{room.getRoomName(), room.getCurrentGuestName()}).m_130940_(ChatFormatting.YELLOW), false);
                continue;
            }
            if (this.warnedRooms.contains(room.getRoomId()) || (remainingTicks = room.getRemainingTime(this.f_58857_)) >= (long)warningTicks) continue;
            this.warnedRooms.add(room.getRoomId());
            if (guest == null || !((Boolean)LCHotelsConfig.SHOW_RENTAL_NOTIFICATIONS.get()).booleanValue()) continue;
            int ticksPerDay = (Integer)LCHotelsConfig.TICKS_PER_RENTAL_DAY.get();
            int hoursLeft = (int)(remainingTicks / (long)(ticksPerDay / 24));
            Object timeText = hoursLeft > 0 ? hoursLeft + " hour(s)" : "less than an hour";
            guest.m_5661_((Component)Component.m_237110_((String)"lchotels.rental.expiring_soon", (Object[])new Object[]{room.getRoomName(), timeText}).m_130940_(ChatFormatting.GOLD), false);
        }
        for (RoomData room : expiredRooms) {
            this.processCheckout(room.getRoomId(), false);
            needsSync = true;
        }
        if (needsSync) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public Component m_5446_() {
        return Component.m_237113_((String)this.hotelName);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new HotelControllerMenu(windowId, playerInventory, this);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.hotelId != null) {
            tag.m_128362_("HotelId", this.hotelId);
        }
        tag.m_128359_("HotelName", this.hotelName);
        if (this.ownerId != null) {
            tag.m_128362_("OwnerId", this.ownerId);
        }
        tag.m_128359_("OwnerName", this.ownerName);
        tag.m_128356_("StoredMoney", this.storedMoney);
        ListTag doorsList = new ListTag();
        for (BlockPos blockPos : this.linkedDoors) {
            doorsList.add((Object)NbtUtils.m_129224_((BlockPos)blockPos));
        }
        tag.m_128365_("LinkedDoors", (Tag)doorsList);
        ListTag desksList = new ListTag();
        for (BlockPos blockPos : this.linkedFrontDesks) {
            desksList.add((Object)NbtUtils.m_129224_((BlockPos)blockPos));
        }
        tag.m_128365_("LinkedFrontDesks", (Tag)desksList);
        ListTag listTag = new ListTag();
        for (RoomData roomData : this.rooms.values()) {
            listTag.add((Object)roomData.save());
        }
        tag.m_128365_("Rooms", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (String string : this.warnedRooms) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("RoomId", string);
            listTag2.add((Object)compoundTag);
        }
        tag.m_128365_("WarnedRooms", (Tag)listTag2);
        ListTag listTag3 = new ListTag();
        for (Map.Entry<UUID, String> entry : this.staffMembers.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("PlayerId", entry.getKey());
            compoundTag.m_128359_("PlayerName", entry.getValue());
            listTag3.add((Object)compoundTag);
        }
        tag.m_128365_("StaffMembers", (Tag)listTag3);
        ListTag listTag4 = new ListTag();
        for (Map.Entry<UUID, String> entry : this.coOwners.entrySet()) {
            CompoundTag coOwnerTag = new CompoundTag();
            coOwnerTag.m_128362_("PlayerId", entry.getKey());
            coOwnerTag.m_128359_("PlayerName", entry.getValue());
            listTag4.add((Object)coOwnerTag);
        }
        tag.m_128365_("CoOwners", (Tag)listTag4);
        ListTag listTag5 = new ListTag();
        for (Map.Entry<RoomType, Set<AmenityType>> entry : this.roomTypeAmenities.entrySet()) {
            CompoundTag typeTag = new CompoundTag();
            typeTag.m_128359_("RoomType", entry.getKey().m_7912_());
            ListTag amenitiesList = new ListTag();
            for (AmenityType amenity : entry.getValue()) {
                CompoundTag amenityTag = new CompoundTag();
                amenityTag.m_128359_("Amenity", amenity.m_7912_());
                amenitiesList.add((Object)amenityTag);
            }
            typeTag.m_128365_("Amenities", (Tag)amenitiesList);
            listTag5.add((Object)typeTag);
        }
        tag.m_128365_("RoomTypeAmenities", (Tag)listTag5);
    }

    public void m_142466_(CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        if (tag.m_128441_("HotelId")) {
            this.hotelId = tag.m_128342_("HotelId");
        }
        this.hotelName = tag.m_128461_("HotelName");
        if (tag.m_128441_("OwnerId")) {
            this.ownerId = tag.m_128342_("OwnerId");
        }
        this.ownerName = tag.m_128461_("OwnerName");
        this.storedMoney = tag.m_128454_("StoredMoney");
        this.linkedDoors.clear();
        if (tag.m_128441_("LinkedDoors")) {
            ListTag doorsList = tag.m_128437_("LinkedDoors", 10);
            for (i = 0; i < doorsList.size(); ++i) {
                this.linkedDoors.add(NbtUtils.m_129239_((CompoundTag)doorsList.m_128728_(i)));
            }
        }
        this.linkedFrontDesks.clear();
        if (tag.m_128441_("LinkedFrontDesks")) {
            ListTag desksList = tag.m_128437_("LinkedFrontDesks", 10);
            for (i = 0; i < desksList.size(); ++i) {
                this.linkedFrontDesks.add(NbtUtils.m_129239_((CompoundTag)desksList.m_128728_(i)));
            }
        }
        this.rooms.clear();
        if (tag.m_128441_("Rooms")) {
            ListTag roomsList = tag.m_128437_("Rooms", 10);
            for (i = 0; i < roomsList.size(); ++i) {
                RoomData room = RoomData.load(roomsList.m_128728_(i));
                this.rooms.put(room.getRoomId(), room);
            }
        }
        this.warnedRooms.clear();
        if (tag.m_128441_("WarnedRooms")) {
            ListTag warnedList = tag.m_128437_("WarnedRooms", 10);
            for (i = 0; i < warnedList.size(); ++i) {
                this.warnedRooms.add(warnedList.m_128728_(i).m_128461_("RoomId"));
            }
        }
        this.staffMembers.clear();
        if (tag.m_128441_("StaffMembers")) {
            ListTag staffList = tag.m_128437_("StaffMembers", 10);
            for (i = 0; i < staffList.size(); ++i) {
                CompoundTag staffTag = staffList.m_128728_(i);
                this.staffMembers.put(staffTag.m_128342_("PlayerId"), staffTag.m_128461_("PlayerName"));
            }
        }
        this.coOwners.clear();
        if (tag.m_128441_("CoOwners")) {
            ListTag coOwnersList = tag.m_128437_("CoOwners", 10);
            for (i = 0; i < coOwnersList.size(); ++i) {
                CompoundTag coOwnerTag = coOwnersList.m_128728_(i);
                this.coOwners.put(coOwnerTag.m_128342_("PlayerId"), coOwnerTag.m_128461_("PlayerName"));
            }
        }
        if (tag.m_128441_("RoomTypeAmenities")) {
            this.roomTypeAmenities.clear();
            ListTag amenitiesConfig = tag.m_128437_("RoomTypeAmenities", 10);
            for (i = 0; i < amenitiesConfig.size(); ++i) {
                CompoundTag typeTag = amenitiesConfig.m_128728_(i);
                RoomType roomType = RoomType.fromString(typeTag.m_128461_("RoomType"));
                HashSet<AmenityType> amenities = new HashSet<AmenityType>();
                ListTag amenitiesList = typeTag.m_128437_("Amenities", 10);
                for (int j = 0; j < amenitiesList.size(); ++j) {
                    amenities.add(AmenityType.fromString(amenitiesList.m_128728_(j).m_128461_("Amenity")));
                }
                this.roomTypeAmenities.put(roomType, amenities);
            }
        } else {
            this.initializeDefaultAmenities();
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

