/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.client.gui;

import com.lchotels.config.LCHotelsConfig;
import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import com.lchotels.menu.FrontDeskMenu;
import com.lchotels.network.LCHotelsNetwork;
import com.lchotels.network.packets.CheckoutPacket;
import com.lchotels.network.packets.ExtendRentalPacket;
import com.lchotels.network.packets.RentRoomPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FrontDeskScreen
extends AbstractContainerScreen<FrontDeskMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("lchotels", "textures/gui/front_desk.png");
    private RoomCategory currentCategory = RoomCategory.GUEST_ROOMS;
    private List<RoomData> guestRooms = new ArrayList<RoomData>();
    private List<RoomData> conferenceRooms = new ArrayList<RoomData>();
    private List<RoomData> myRentals = new ArrayList<RoomData>();
    private int scrollOffset = 0;
    private int selectedRoomIndex = -1;
    private int selectedDays = 1;
    private Button rentButton;
    private Button checkoutButton;
    private Button extendButton;
    private Button daysUpButton;
    private Button daysDownButton;
    private Button tabGuestButton;
    private Button tabConferenceButton;
    private Button tabMyRentalsButton;

    public FrontDeskScreen(FrontDeskMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 280;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.selectedDays = (Integer)LCHotelsConfig.MIN_RENTAL_DAYS.get();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.tabGuestButton = Button.m_253074_((Component)Component.m_237113_((String)"Guest Rooms"), btn -> this.switchCategory(RoomCategory.GUEST_ROOMS)).m_252987_(x + 5, y + 18, 70, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.tabGuestButton);
        this.tabConferenceButton = Button.m_253074_((Component)Component.m_237113_((String)"Conference"), btn -> this.switchCategory(RoomCategory.CONFERENCE_ROOMS)).m_252987_(x + 77, y + 18, 60, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.tabConferenceButton);
        this.tabMyRentalsButton = Button.m_253074_((Component)Component.m_237113_((String)"My Rentals"), btn -> this.switchCategory(RoomCategory.MY_RENTALS)).m_252987_(x + 139, y + 18, 60, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.tabMyRentalsButton);
        this.daysDownButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), btn -> this.adjustDays(-1)).m_252987_(x + 185, y + 100, 20, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.daysDownButton);
        this.daysUpButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), btn -> this.adjustDays(1)).m_252987_(x + 245, y + 100, 20, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.daysUpButton);
        this.rentButton = Button.m_253074_((Component)Component.m_237115_((String)"lchotels.gui.front_desk.rent_room"), btn -> this.rentRoom()).m_252987_(x + 185, y + 120, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.rentButton);
        this.extendButton = Button.m_253074_((Component)Component.m_237113_((String)"Extend"), btn -> this.extendRental()).m_252987_(x + 185, y + 120, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.extendButton);
        this.checkoutButton = Button.m_253074_((Component)Component.m_237115_((String)"lchotels.gui.front_desk.checkout"), btn -> this.checkout()).m_252987_(x + 185, y + 145, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.checkoutButton);
        this.updateRoomLists();
        this.updateButtonStates();
    }

    private void switchCategory(RoomCategory category) {
        this.currentCategory = category;
        this.scrollOffset = 0;
        this.selectedRoomIndex = -1;
        this.selectedDays = (Integer)LCHotelsConfig.MIN_RENTAL_DAYS.get();
        this.updateButtonStates();
    }

    private void adjustDays(int delta) {
        int minDays = (Integer)LCHotelsConfig.MIN_RENTAL_DAYS.get();
        int maxDays = (Integer)LCHotelsConfig.MAX_RENTAL_DAYS.get();
        if (this.currentCategory == RoomCategory.MY_RENTALS && this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.myRentals.size()) {
            RoomData room = this.myRentals.get(this.selectedRoomIndex);
            int remainingDays = room.getRemainingDays(((FrontDeskMenu)this.f_97732_).getBlockEntity().m_58904_());
            int maxAdditional = maxDays - remainingDays;
            this.selectedDays = Math.max(minDays, Math.min(maxAdditional, this.selectedDays + delta));
        } else {
            this.selectedDays = Math.max(minDays, Math.min(maxDays, this.selectedDays + delta));
        }
    }

    private void updateRoomLists() {
        this.guestRooms.clear();
        this.conferenceRooms.clear();
        this.myRentals.clear();
        for (RoomData room : ((FrontDeskMenu)this.f_97732_).getAvailableRooms()) {
            if (room.getRoomType().isConferenceRoom()) {
                this.conferenceRooms.add(room);
                continue;
            }
            this.guestRooms.add(room);
        }
        this.guestRooms.sort((a, b) -> {
            int typeCompare = a.getRoomType().ordinal() - b.getRoomType().ordinal();
            if (typeCompare != 0) {
                return typeCompare;
            }
            return a.getRoomName().compareTo(b.getRoomName());
        });
        this.conferenceRooms.sort((a, b) -> {
            int typeCompare = a.getRoomType().ordinal() - b.getRoomType().ordinal();
            if (typeCompare != 0) {
                return typeCompare;
            }
            return a.getRoomName().compareTo(b.getRoomName());
        });
        this.myRentals.addAll(((FrontDeskMenu)this.f_97732_).getPlayerRentals());
        List<RoomData> currentList = this.getCurrentList();
        if (this.selectedRoomIndex >= currentList.size()) {
            this.selectedRoomIndex = -1;
        }
    }

    private List<RoomData> getCurrentList() {
        return switch (this.currentCategory) {
            default -> throw new IncompatibleClassChangeError();
            case RoomCategory.GUEST_ROOMS -> this.guestRooms;
            case RoomCategory.CONFERENCE_ROOMS -> this.conferenceRooms;
            case RoomCategory.MY_RENTALS -> this.myRentals;
        };
    }

    private void updateButtonStates() {
        List<RoomData> currentList = this.getCurrentList();
        boolean hasSelection = this.selectedRoomIndex >= 0 && this.selectedRoomIndex < currentList.size();
        boolean isLinked = ((FrontDeskMenu)this.f_97732_).isLinked();
        boolean isMyRentals = this.currentCategory == RoomCategory.MY_RENTALS;
        this.tabGuestButton.f_93623_ = this.currentCategory != RoomCategory.GUEST_ROOMS;
        this.tabConferenceButton.f_93623_ = this.currentCategory != RoomCategory.CONFERENCE_ROOMS;
        this.tabMyRentalsButton.f_93623_ = this.currentCategory != RoomCategory.MY_RENTALS;
        this.rentButton.f_93624_ = !isMyRentals;
        this.rentButton.f_93623_ = hasSelection && isLinked && !isMyRentals;
        this.extendButton.f_93624_ = isMyRentals;
        this.extendButton.f_93623_ = hasSelection && isLinked && isMyRentals;
        this.daysUpButton.f_93624_ = true;
        this.daysDownButton.f_93624_ = true;
        this.daysUpButton.f_93623_ = isLinked;
        this.daysDownButton.f_93623_ = isLinked;
        this.checkoutButton.f_93624_ = isMyRentals;
        this.checkoutButton.f_93623_ = hasSelection && isLinked && isMyRentals;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updateRoomLists();
        this.updateButtonStates();
    }

    private void rentRoom() {
        if (this.currentCategory == RoomCategory.MY_RENTALS) {
            return;
        }
        List<RoomData> currentList = this.getCurrentList();
        if (this.selectedRoomIndex >= 0 && this.selectedRoomIndex < currentList.size() && ((FrontDeskMenu)this.f_97732_).isLinked()) {
            RoomData room = currentList.get(this.selectedRoomIndex);
            LCHotelsNetwork.sendToServer(new RentRoomPacket(((FrontDeskMenu)this.f_97732_).getBlockEntity().getLinkedControllerPos(), room.getRoomId(), this.selectedDays));
            this.selectedRoomIndex = -1;
            this.updateButtonStates();
        }
    }

    private void extendRental() {
        if (this.currentCategory != RoomCategory.MY_RENTALS) {
            return;
        }
        if (this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.myRentals.size() && ((FrontDeskMenu)this.f_97732_).isLinked()) {
            RoomData room = this.myRentals.get(this.selectedRoomIndex);
            LCHotelsNetwork.sendToServer(new ExtendRentalPacket(((FrontDeskMenu)this.f_97732_).getBlockEntity().getLinkedControllerPos(), room.getRoomId(), this.selectedDays));
        }
    }

    private void checkout() {
        if (this.currentCategory != RoomCategory.MY_RENTALS) {
            return;
        }
        if (this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.myRentals.size() && ((FrontDeskMenu)this.f_97732_).isLinked()) {
            RoomData room = this.myRentals.get(this.selectedRoomIndex);
            LCHotelsNetwork.sendToServer(new CheckoutPacket(((FrontDeskMenu)this.f_97732_).getBlockEntity().getLinkedControllerPos(), room.getRoomId(), true));
            this.selectedRoomIndex = -1;
            this.updateButtonStates();
        }
    }

    /*
     * Exception decompiling
     */
    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:97)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getShortTypeName(RoomType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RoomType.STANDARD -> "Std";
            case RoomType.DELUXE -> "Dlx";
            case RoomType.SUITE -> "Suite";
            case RoomType.PENTHOUSE -> "PH";
            case RoomType.CONFERENCE_SMALL -> "Sm";
            case RoomType.CONFERENCE_MEDIUM -> "Med";
            case RoomType.CONFERENCE_LARGE -> "Lg";
            case RoomType.BALLROOM -> "Ball";
        };
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int listTop = y + 38;
        int listBottom = y + 38 + 105;
        int listLeft = x + 9;
        int listRight = x + 174;
        if (mouseX >= (double)listLeft && mouseX <= (double)listRight && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            List<RoomData> currentList = this.getCurrentList();
            int clickedIndex = this.scrollOffset + (int)((mouseY - (double)listTop) / 15.0);
            if (clickedIndex >= 0 && clickedIndex < currentList.size()) {
                this.selectedRoomIndex = clickedIndex;
                this.selectedDays = (Integer)LCHotelsConfig.MIN_RENTAL_DAYS.get();
                this.updateButtonStates();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        List<RoomData> currentList = this.getCurrentList();
        int maxRooms = 7;
        if (delta > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
            return true;
        }
        if (delta < 0.0 && this.scrollOffset < currentList.size() - maxRooms) {
            ++this.scrollOffset;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static enum RoomCategory {
        GUEST_ROOMS("Guest Rooms", false),
        CONFERENCE_ROOMS("Conference Rooms", true),
        MY_RENTALS("My Rentals", false);

        final String displayName;
        final boolean isConference;

        private RoomCategory(String displayName, boolean isConference) {
            this.displayName = displayName;
            this.isConference = isConference;
        }
    }
}

