/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.client.gui;

import com.lchotels.data.AmenityType;
import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import com.lchotels.menu.HotelControllerMenu;
import com.lchotels.network.LCHotelsNetwork;
import com.lchotels.network.packets.CreateOwnerKeycardPacket;
import com.lchotels.network.packets.CreateRoomPacket;
import com.lchotels.network.packets.DeleteRoomPacket;
import com.lchotels.network.packets.ManageStaffPacket;
import com.lchotels.network.packets.RenameHotelPacket;
import com.lchotels.network.packets.SelectRoomPacket;
import com.lchotels.network.packets.ToggleAmenityPacket;
import com.lchotels.network.packets.UpdateRoomPricePacket;
import com.lchotels.network.packets.WithdrawMoneyPacket;
import com.lchotels.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class HotelControllerScreen
extends AbstractContainerScreen<HotelControllerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("lchotels", "textures/gui/hotel_controller.png");
    private Tab currentTab = Tab.ROOMS;
    private EditBox hotelNameField;
    private Button renameButton;
    private Button tabRoomsButton;
    private Button tabStaffButton;
    private Button tabAmenitiesButton;
    private EditBox roomNumberField;
    private EditBox priceField;
    private EditBox editPriceField;
    private Button createRoomButton;
    private Button withdrawButton;
    private Button deleteRoomButton;
    private Button selectRoomButton;
    private Button ownerKeycardButton;
    private Button setPriceButton;
    private int selectedRoomTypeIndex = 0;
    private Button roomTypeButton;
    private EditBox staffNameField;
    private Button addStaffButton;
    private Button addCoOwnerButton;
    private List<Button> removeStaffButtons = new ArrayList<Button>();
    private List<Button> removeCoOwnerButtons = new ArrayList<Button>();
    private int selectedAmenityRoomTypeIndex = 0;
    private Button amenityRoomTypeButton;
    private List<Button> amenityToggleButtons = new ArrayList<Button>();
    private List<RoomData> roomList = new ArrayList<RoomData>();
    private int scrollOffset = 0;
    private int selectedRoomIndex = -1;
    private boolean isEditingName = false;

    public HotelControllerScreen(HotelControllerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 280;
        this.f_97727_ = 240;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.hotelNameField = new EditBox(this.f_96547_, x + 40, y + 3, 150, 12, (Component)Component.m_237113_((String)"Hotel Name"));
        this.hotelNameField.m_94199_(32);
        this.hotelNameField.m_94144_(((HotelControllerMenu)this.f_97732_).getHotelName());
        this.hotelNameField.m_94194_(false);
        this.hotelNameField.m_94182_(true);
        this.m_142416_((GuiEventListener)this.hotelNameField);
        this.renameButton = Button.m_253074_((Component)Component.m_237113_((String)"\u270e"), btn -> this.toggleNameEdit()).m_252987_(x + 195, y + 2, 14, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.renameButton);
        this.tabRoomsButton = Button.m_253074_((Component)Component.m_237113_((String)"Rooms"), btn -> this.switchTab(Tab.ROOMS)).m_252987_(x + 10, y + 18, 50, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.tabRoomsButton);
        this.tabStaffButton = Button.m_253074_((Component)Component.m_237113_((String)"Staff"), btn -> this.switchTab(Tab.STAFF)).m_252987_(x + 65, y + 18, 50, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.tabStaffButton);
        this.tabAmenitiesButton = Button.m_253074_((Component)Component.m_237113_((String)"Amenities"), btn -> this.switchTab(Tab.AMENITIES)).m_252987_(x + 120, y + 18, 60, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.tabAmenitiesButton);
        this.initRoomsTab(x, y);
        this.initStaffTab(x, y);
        this.initAmenitiesTab(x, y);
        this.updateRoomList();
        this.switchTab(Tab.ROOMS);
    }

    private void initRoomsTab(int x, int y) {
        this.roomNumberField = new EditBox(this.f_96547_, x + 10, y + 40, 60, 16, (Component)Component.m_237113_((String)"Room #"));
        this.roomNumberField.m_94199_(10);
        this.roomNumberField.m_94144_("101");
        this.m_142416_((GuiEventListener)this.roomNumberField);
        this.priceField = new EditBox(this.f_96547_, x + 10, y + 62, 60, 16, (Component)Component.m_237113_((String)"Price"));
        this.priceField.m_94199_(10);
        this.priceField.m_94144_("100");
        this.m_142416_((GuiEventListener)this.priceField);
        this.roomTypeButton = Button.m_253074_((Component)Component.m_237113_((String)RoomType.values()[this.selectedRoomTypeIndex].getDisplayName()), btn -> this.cycleRoomType()).m_252987_(x + 75, y + 40, 80, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.roomTypeButton);
        this.createRoomButton = Button.m_253074_((Component)Component.m_237113_((String)"Create"), btn -> this.createRoom()).m_252987_(x + 75, y + 62, 40, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.createRoomButton);
        this.withdrawButton = Button.m_253074_((Component)Component.m_237113_((String)"Withdraw"), btn -> this.withdrawMoney()).m_252987_(x + 160, y + 40, 55, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.withdrawButton);
        this.ownerKeycardButton = Button.m_253074_((Component)Component.m_237113_((String)"Master Key"), btn -> this.createOwnerKeycard()).m_252987_(x + 160, y + 62, 55, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.ownerKeycardButton);
        this.editPriceField = new EditBox(this.f_96547_, x + 60, y + 215, 50, 16, (Component)Component.m_237113_((String)"Edit Price"));
        this.editPriceField.m_94199_(10);
        this.editPriceField.m_94194_(false);
        this.m_142416_((GuiEventListener)this.editPriceField);
        this.setPriceButton = Button.m_253074_((Component)Component.m_237113_((String)"Set Price"), btn -> this.setRoomPrice()).m_252987_(x + 112, y + 215, 45, 16).m_253136_();
        this.setPriceButton.f_93623_ = false;
        this.setPriceButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.setPriceButton);
        this.selectRoomButton = Button.m_253074_((Component)Component.m_237113_((String)"Select"), btn -> this.selectRoom()).m_252987_(x + 160, y + 215, 50, 16).m_253136_();
        this.selectRoomButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.selectRoomButton);
        this.deleteRoomButton = Button.m_253074_((Component)Component.m_237113_((String)"Delete"), btn -> this.deleteRoom()).m_252987_(x + 215, y + 215, 50, 16).m_253136_();
        this.deleteRoomButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.deleteRoomButton);
    }

    private void initStaffTab(int x, int y) {
        this.staffNameField = new EditBox(this.f_96547_, x + 10, y + 45, 100, 16, (Component)Component.m_237113_((String)"Player Name"));
        this.staffNameField.m_94199_(16);
        this.m_142416_((GuiEventListener)this.staffNameField);
        this.addStaffButton = Button.m_253074_((Component)Component.m_237113_((String)"Add Staff"), btn -> this.addStaff()).m_252987_(x + 115, y + 45, 60, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.addStaffButton);
        this.addCoOwnerButton = Button.m_253074_((Component)Component.m_237113_((String)"Add Co-Owner"), btn -> this.addCoOwner()).m_252987_(x + 180, y + 45, 75, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.addCoOwnerButton);
    }

    private void initAmenitiesTab(int x, int y) {
        this.amenityRoomTypeButton = Button.m_253074_((Component)Component.m_237113_((String)RoomType.values()[this.selectedAmenityRoomTypeIndex].getDisplayName()), btn -> this.cycleAmenityRoomType()).m_252987_(x + 10, y + 45, 120, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.amenityRoomTypeButton);
        int buttonY = y + 70;
        int col = 0;
        for (AmenityType amenity : AmenityType.values()) {
            int bx = x + 10 + col % 2 * 130;
            int by = buttonY + col / 2 * 20;
            Button btn2 = Button.m_253074_((Component)Component.m_237113_((String)amenity.getDisplayName()), b -> this.toggleAmenity(amenity)).m_252987_(bx, by, 125, 18).m_253136_();
            this.amenityToggleButtons.add(btn2);
            this.m_142416_((GuiEventListener)btn2);
            ++col;
        }
    }

    private void switchTab(Tab tab) {
        this.currentTab = tab;
        this.tabRoomsButton.f_93623_ = tab != Tab.ROOMS;
        this.tabStaffButton.f_93623_ = tab != Tab.STAFF;
        this.tabAmenitiesButton.f_93623_ = tab != Tab.AMENITIES;
        this.setRoomsTabVisible(tab == Tab.ROOMS);
        this.setStaffTabVisible(tab == Tab.STAFF);
        this.setAmenitiesTabVisible(tab == Tab.AMENITIES);
        if (tab == Tab.AMENITIES) {
            this.updateAmenityButtons();
        }
        if (tab == Tab.STAFF) {
            this.rebuildStaffButtons();
        }
    }

    private void setRoomsTabVisible(boolean visible) {
        this.roomNumberField.m_94194_(visible);
        this.priceField.m_94194_(visible);
        this.roomTypeButton.f_93624_ = visible;
        this.createRoomButton.f_93624_ = visible;
        this.withdrawButton.f_93624_ = visible;
        this.ownerKeycardButton.f_93624_ = visible;
        this.selectRoomButton.f_93624_ = visible;
        this.deleteRoomButton.f_93624_ = visible;
        if (!visible) {
            this.editPriceField.m_94194_(false);
            this.setPriceButton.f_93624_ = false;
        } else {
            this.updateButtonStates();
        }
    }

    private void setStaffTabVisible(boolean visible) {
        this.staffNameField.m_94194_(visible);
        this.addStaffButton.f_93624_ = visible;
        this.addCoOwnerButton.f_93624_ = visible;
        for (Button btn : this.removeStaffButtons) {
            btn.f_93624_ = visible;
        }
        for (Button btn : this.removeCoOwnerButtons) {
            btn.f_93624_ = visible;
        }
    }

    private void setAmenitiesTabVisible(boolean visible) {
        this.amenityRoomTypeButton.f_93624_ = visible;
        for (Button btn : this.amenityToggleButtons) {
            btn.f_93624_ = visible;
        }
    }

    private void rebuildStaffButtons() {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        for (Button btn : this.removeStaffButtons) {
            this.m_169411_((GuiEventListener)btn);
        }
        this.removeStaffButtons.clear();
        for (Button btn : this.removeCoOwnerButtons) {
            this.m_169411_((GuiEventListener)btn);
        }
        this.removeCoOwnerButtons.clear();
        Map<UUID, String> staff = ((HotelControllerMenu)this.f_97732_).getBlockEntity().getStaffMembers();
        int staffY = y + 80;
        for (Map.Entry<UUID, String> entry : staff.entrySet()) {
            UUID staffId = entry.getKey();
            Button btn = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> this.removeStaff(staffId)).m_252987_(x + 240, staffY, 20, 14).m_253136_();
            this.removeStaffButtons.add(btn);
            this.m_142416_((GuiEventListener)btn);
            staffY += 16;
        }
        Map<UUID, String> coOwners = ((HotelControllerMenu)this.f_97732_).getBlockEntity().getCoOwners();
        int coOwnerY = y + 150;
        for (Map.Entry<UUID, String> entry : coOwners.entrySet()) {
            UUID coOwnerId = entry.getKey();
            Button btn = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> this.removeCoOwner(coOwnerId)).m_252987_(x + 240, coOwnerY, 20, 14).m_253136_();
            this.removeCoOwnerButtons.add(btn);
            this.m_142416_((GuiEventListener)btn);
            coOwnerY += 16;
        }
    }

    private void updateAmenityButtons() {
        RoomType selectedType = RoomType.values()[this.selectedAmenityRoomTypeIndex];
        Set<AmenityType> enabledAmenities = ((HotelControllerMenu)this.f_97732_).getBlockEntity().getAmenitiesForRoomType(selectedType);
        int i = 0;
        for (AmenityType amenity : AmenityType.values()) {
            if (i < this.amenityToggleButtons.size()) {
                Button btn = this.amenityToggleButtons.get(i);
                boolean enabled = enabledAmenities.contains((Object)amenity);
                String prefix = enabled ? "\u2713 " : "\u2717 ";
                btn.m_93666_((Component)Component.m_237113_((String)(prefix + amenity.getDisplayName())));
            }
            ++i;
        }
    }

    private void toggleNameEdit() {
        if (this.isEditingName) {
            String newName = this.hotelNameField.m_94155_().trim();
            if (!newName.isEmpty() && !newName.equals(((HotelControllerMenu)this.f_97732_).getHotelName())) {
                LCHotelsNetwork.sendToServer(new RenameHotelPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), newName));
            }
            this.isEditingName = false;
            this.hotelNameField.m_94194_(false);
            this.renameButton.m_93666_((Component)Component.m_237113_((String)"\u270e"));
        } else {
            this.isEditingName = true;
            this.hotelNameField.m_94144_(((HotelControllerMenu)this.f_97732_).getHotelName());
            this.hotelNameField.m_94194_(true);
            this.hotelNameField.m_93692_(true);
            this.renameButton.m_93666_((Component)Component.m_237113_((String)"\u2713"));
        }
    }

    private void cycleRoomType() {
        this.selectedRoomTypeIndex = (this.selectedRoomTypeIndex + 1) % RoomType.values().length;
        this.roomTypeButton.m_93666_((Component)Component.m_237113_((String)RoomType.values()[this.selectedRoomTypeIndex].getDisplayName()));
    }

    private void cycleAmenityRoomType() {
        this.selectedAmenityRoomTypeIndex = (this.selectedAmenityRoomTypeIndex + 1) % RoomType.values().length;
        this.amenityRoomTypeButton.m_93666_((Component)Component.m_237113_((String)RoomType.values()[this.selectedAmenityRoomTypeIndex].getDisplayName()));
        this.updateAmenityButtons();
    }

    private void toggleAmenity(AmenityType amenity) {
        RoomType roomType = RoomType.values()[this.selectedAmenityRoomTypeIndex];
        LCHotelsNetwork.sendToServer(new ToggleAmenityPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), roomType, amenity));
        ((HotelControllerMenu)this.f_97732_).getBlockEntity().toggleAmenityForRoomType(roomType, amenity);
        this.updateAmenityButtons();
    }

    private void addStaff() {
        String name = this.staffNameField.m_94155_().trim();
        if (!name.isEmpty()) {
            LCHotelsNetwork.sendToServer(new ManageStaffPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), ManageStaffPacket.Action.ADD_STAFF, name));
            this.staffNameField.m_94144_("");
        }
    }

    private void addCoOwner() {
        String name = this.staffNameField.m_94155_().trim();
        if (!name.isEmpty()) {
            LCHotelsNetwork.sendToServer(new ManageStaffPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), ManageStaffPacket.Action.ADD_COOWNER, name));
            this.staffNameField.m_94144_("");
        }
    }

    private void removeStaff(UUID staffId) {
        LCHotelsNetwork.sendToServer(new ManageStaffPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), ManageStaffPacket.Action.REMOVE_STAFF, staffId));
    }

    private void removeCoOwner(UUID coOwnerId) {
        LCHotelsNetwork.sendToServer(new ManageStaffPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), ManageStaffPacket.Action.REMOVE_COOWNER, coOwnerId));
    }

    private void createRoom() {
        try {
            String roomNumber = this.roomNumberField.m_94155_().trim();
            if (roomNumber.isEmpty()) {
                return;
            }
            long price = Long.parseLong(this.priceField.m_94155_());
            if (price < 0L) {
                return;
            }
            RoomType type = RoomType.values()[this.selectedRoomTypeIndex];
            LCHotelsNetwork.sendToServer(new CreateRoomPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), roomNumber, type, price));
            try {
                int num = Integer.parseInt(roomNumber);
                this.roomNumberField.m_94144_(String.valueOf(num + 1));
            }
            catch (NumberFormatException e) {
                this.roomNumberField.m_94144_("");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void withdrawMoney() {
        LCHotelsNetwork.sendToServer(new WithdrawMoneyPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), 0L));
    }

    private void createOwnerKeycard() {
        LCHotelsNetwork.sendToServer(new CreateOwnerKeycardPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_()));
    }

    private void selectRoom() {
        if (this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.roomList.size()) {
            RoomData room = this.roomList.get(this.selectedRoomIndex);
            LCHotelsNetwork.sendToServer(new SelectRoomPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), room.getRoomId(), room.getRoomName()));
        }
    }

    private void deleteRoom() {
        RoomData room;
        if (this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.roomList.size() && !(room = this.roomList.get(this.selectedRoomIndex)).isRented()) {
            LCHotelsNetwork.sendToServer(new DeleteRoomPacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), room.getRoomId()));
            this.selectedRoomIndex = -1;
            this.updateButtonStates();
        }
    }

    private void setRoomPrice() {
        if (this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.roomList.size()) {
            RoomData room = this.roomList.get(this.selectedRoomIndex);
            try {
                long newPrice = Long.parseLong(this.editPriceField.m_94155_());
                if (newPrice >= 0L) {
                    LCHotelsNetwork.sendToServer(new UpdateRoomPricePacket(((HotelControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), room.getRoomId(), newPrice));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void updateRoomList() {
        this.roomList.clear();
        this.roomList.addAll(((HotelControllerMenu)this.f_97732_).getAllRooms());
        if (this.selectedRoomIndex >= this.roomList.size()) {
            this.selectedRoomIndex = -1;
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean hasSelection;
        if (this.currentTab != Tab.ROOMS) {
            return;
        }
        this.selectRoomButton.f_93623_ = hasSelection = this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.roomList.size();
        this.editPriceField.m_94194_(hasSelection);
        this.setPriceButton.f_93624_ = hasSelection;
        this.setPriceButton.f_93623_ = hasSelection;
        if (hasSelection) {
            RoomData room = this.roomList.get(this.selectedRoomIndex);
            boolean bl = this.deleteRoomButton.f_93623_ = !room.isRented();
            if (this.editPriceField.m_94155_().isEmpty() || !this.editPriceField.m_93696_()) {
                this.editPriceField.m_94144_(String.valueOf(room.getPricePerDay()));
            }
        } else {
            this.deleteRoomButton.f_93623_ = false;
            this.editPriceField.m_94144_("");
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updateRoomList();
        if (!this.isEditingName && this.hotelNameField != null) {
            String serverName = ((HotelControllerMenu)this.f_97732_).getHotelName();
            if (!this.hotelNameField.m_94155_().equals(serverName)) {
                this.hotelNameField.m_94144_(serverName);
            }
        }
        if (this.currentTab == Tab.STAFF) {
            int currentStaffCount = this.removeStaffButtons.size();
            int currentCoOwnerCount = this.removeCoOwnerButtons.size();
            int actualStaffCount = ((HotelControllerMenu)this.f_97732_).getBlockEntity().getStaffMembers().size();
            int actualCoOwnerCount = ((HotelControllerMenu)this.f_97732_).getBlockEntity().getCoOwners().size();
            if (currentStaffCount != actualStaffCount || currentCoOwnerCount != actualCoOwnerCount) {
                this.rebuildStaffButtons();
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280509_(x, y, x + this.f_97726_, y + this.f_97727_, -12566464);
        graphics.m_280509_(x + 2, y + 2, x + this.f_97726_ - 2, y + this.f_97727_ - 2, -14671840);
        graphics.m_280509_(x + 2, y + 2, x + this.f_97726_ - 2, y + 18, -11513776);
        if (!this.isEditingName) {
            graphics.m_280137_(this.f_96547_, ((HotelControllerMenu)this.f_97732_).getHotelName(), x + this.f_97726_ / 2, y + 6, 0xFFFFFF);
        }
        long storedMoney = ((HotelControllerMenu)this.f_97732_).getStoredMoney();
        String moneyText = "Bank: " + MoneyUtil.formatMoney(storedMoney);
        graphics.m_280488_(this.f_96547_, moneyText, x + 185, y + 20, 16766720);
        switch (this.currentTab) {
            case ROOMS: {
                this.renderRoomsTab(graphics, x, y, mouseX, mouseY);
                break;
            }
            case STAFF: {
                this.renderStaffTab(graphics, x, y, mouseX, mouseY);
                break;
            }
            case AMENITIES: {
                this.renderAmenitiesTab(graphics, x, y, mouseX, mouseY);
            }
        }
    }

    private void renderRoomsTab(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280488_(this.f_96547_, "Room #:", x + 10, y + 32, 0xAAAAAA);
        graphics.m_280488_(this.f_96547_, "Price:", x + 10, y + 54, 0xAAAAAA);
        graphics.m_280509_(x + 8, y + 83, x + this.f_97726_ - 8, y + 95, -13092808);
        graphics.m_280488_(this.f_96547_, "Room", x + 12, y + 85, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Type", x + 80, y + 85, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Price/Day", x + 150, y + 85, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Status", x + 220, y + 85, 0xFFFFFF);
        int roomY = y + 97;
        int maxRooms = 7;
        int rowHeight = 14;
        for (int i = this.scrollOffset; i < Math.min(this.scrollOffset + maxRooms, this.roomList.size()); ++i) {
            RoomData room = this.roomList.get(i);
            int rowY = roomY + (i - this.scrollOffset) * rowHeight;
            if (i == this.selectedRoomIndex) {
                graphics.m_280509_(x + 8, rowY - 1, x + this.f_97726_ - 8, rowY + rowHeight - 1, -12294486);
            } else if ((i - this.scrollOffset) % 2 == 0) {
                graphics.m_280509_(x + 8, rowY - 1, x + this.f_97726_ - 8, rowY + rowHeight - 1, -14013910);
            }
            graphics.m_280488_(this.f_96547_, room.getRoomName(), x + 12, rowY + 1, 0xCCCCCC);
            Object typeStr = room.getRoomType().getDisplayName();
            if (((String)typeStr).length() > 10) {
                typeStr = ((String)typeStr).substring(0, 9) + "..";
            }
            graphics.m_280488_(this.f_96547_, (String)typeStr, x + 80, rowY + 1, 0x888888);
            graphics.m_280488_(this.f_96547_, MoneyUtil.formatMoney(room.getPricePerDay()), x + 150, rowY + 1, 16766720);
            String status = room.isAvailable() ? "Available" : "Occupied";
            int statusColor = room.isAvailable() ? 65280 : 0xFF6666;
            graphics.m_280488_(this.f_96547_, status, x + 220, rowY + 1, statusColor);
        }
        if (this.scrollOffset > 0) {
            graphics.m_280137_(this.f_96547_, "\u25b2", x + this.f_97726_ / 2, y + 85, 0xFFFFFF);
        }
        if (this.scrollOffset + maxRooms < this.roomList.size()) {
            graphics.m_280137_(this.f_96547_, "\u25bc", x + this.f_97726_ / 2, y + 97 + maxRooms * rowHeight, 0xFFFFFF);
        }
        graphics.m_280488_(this.f_96547_, "Rooms: " + this.roomList.size(), x + 10, y + 200, 0xAAAAAA);
        if (this.selectedRoomIndex >= 0 && this.selectedRoomIndex < this.roomList.size()) {
            graphics.m_280488_(this.f_96547_, "Price:", x + 10, y + 218, 0xAAAAAA);
        } else {
            graphics.m_280488_(this.f_96547_, "Click room to select", x + 10, y + 218, 0x666666);
        }
    }

    private void renderStaffTab(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280488_(this.f_96547_, "Enter player name:", x + 10, y + 36, 0xAAAAAA);
        graphics.m_280488_(this.f_96547_, "Staff Members:", x + 10, y + 68, 0xFFFFFF);
        graphics.m_280509_(x + 8, y + 78, x + this.f_97726_ - 8, y + 79, -11184811);
        Map<UUID, String> staff = ((HotelControllerMenu)this.f_97732_).getBlockEntity().getStaffMembers();
        int staffY = y + 82;
        if (staff.isEmpty()) {
            graphics.m_280488_(this.f_96547_, "No staff members", x + 15, staffY, 0x666666);
        } else {
            for (String name : staff.values()) {
                graphics.m_280488_(this.f_96547_, "\u2022 " + name, x + 15, staffY, 0xCCCCCC);
                staffY += 16;
            }
        }
        graphics.m_280488_(this.f_96547_, "Co-Owners:", x + 10, y + 138, 0xFFFFFF);
        graphics.m_280509_(x + 8, y + 148, x + this.f_97726_ - 8, y + 149, -11184811);
        Map<UUID, String> coOwners = ((HotelControllerMenu)this.f_97732_).getBlockEntity().getCoOwners();
        int coOwnerY = y + 152;
        if (coOwners.isEmpty()) {
            graphics.m_280488_(this.f_96547_, "No co-owners", x + 15, coOwnerY, 0x666666);
        } else {
            for (String name : coOwners.values()) {
                graphics.m_280488_(this.f_96547_, "\u2022 " + name, x + 15, coOwnerY, 0xCCCCCC);
                coOwnerY += 16;
            }
        }
        graphics.m_280488_(this.f_96547_, "Staff: Can manage rooms", x + 10, y + 205, 0x888888);
        graphics.m_280488_(this.f_96547_, "Co-Owners: Full access + withdraw", x + 10, y + 218, 0x888888);
    }

    private void renderAmenitiesTab(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280488_(this.f_96547_, "Select room type:", x + 10, y + 36, 0xAAAAAA);
        graphics.m_280488_(this.f_96547_, "Toggle amenities for this room type:", x + 10, y + 63, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Guests in rooms of this type will have access", x + 10, y + 200, 0x888888);
        graphics.m_280488_(this.f_96547_, "to the selected amenities.", x + 10, y + 212, 0x888888);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.currentTab == Tab.ROOMS) {
            int clickedRow;
            int clickedIndex;
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            int listX = x + 8;
            int listY = y + 97;
            int listWidth = this.f_97726_ - 16;
            int rowHeight = 14;
            int maxRooms = 7;
            if (mouseX >= (double)listX && mouseX < (double)(listX + listWidth) && mouseY >= (double)listY && mouseY < (double)(listY + maxRooms * rowHeight) && (clickedIndex = this.scrollOffset + (clickedRow = (int)((mouseY - (double)listY) / (double)rowHeight))) >= 0 && clickedIndex < this.roomList.size()) {
                if (this.selectedRoomIndex != clickedIndex) {
                    this.selectedRoomIndex = clickedIndex;
                    RoomData room = this.roomList.get(this.selectedRoomIndex);
                    this.editPriceField.m_94144_(String.valueOf(room.getPricePerDay()));
                }
                this.updateButtonStates();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.currentTab == Tab.ROOMS) {
            int maxRooms = 7;
            if (delta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
                return true;
            }
            if (delta < 0.0 && this.scrollOffset < this.roomList.size() - maxRooms) {
                ++this.scrollOffset;
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            if (this.isEditingName && this.hotelNameField.m_93696_()) {
                this.toggleNameEdit();
                return true;
            }
            if (this.currentTab == Tab.ROOMS && this.editPriceField.m_93696_()) {
                this.setRoomPrice();
                return true;
            }
            if (this.currentTab == Tab.STAFF && this.staffNameField.m_93696_()) {
                this.addStaff();
                return true;
            }
        }
        if (this.hotelNameField.m_93696_() || this.roomNumberField.m_93696_() || this.priceField.m_93696_() || this.editPriceField.m_93696_() || this.staffNameField.m_93696_()) {
            if (keyCode == 256) {
                if (this.isEditingName) {
                    this.isEditingName = false;
                    this.hotelNameField.m_94194_(false);
                    this.hotelNameField.m_94144_(((HotelControllerMenu)this.f_97732_).getHotelName());
                    this.renameButton.m_93666_((Component)Component.m_237113_((String)"\u270e"));
                }
                this.hotelNameField.m_93692_(false);
                this.roomNumberField.m_93692_(false);
                this.priceField.m_93692_(false);
                this.editPriceField.m_93692_(false);
                this.staffNameField.m_93692_(false);
                return true;
            }
            return this.hotelNameField.m_7933_(keyCode, scanCode, modifiers) || this.roomNumberField.m_7933_(keyCode, scanCode, modifiers) || this.priceField.m_7933_(keyCode, scanCode, modifiers) || this.editPriceField.m_7933_(keyCode, scanCode, modifiers) || this.staffNameField.m_7933_(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private static enum Tab {
        ROOMS,
        STAFF,
        AMENITIES;

    }
}

