/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.compat.jade;

import com.lchotels.block.BaseAmenityDoorBlock;
import com.lchotels.blockentity.AmenityDoorBlockEntity;
import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.compat.jade.LCHotelsJadePlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum AmenityDoorComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    private BlockPos getLowerPos(BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof BaseAmenityDoorBlock && state.m_61138_(BaseAmenityDoorBlock.HALF) && state.m_61143_(BaseAmenityDoorBlock.HALF) == DoubleBlockHalf.UPPER) {
            return pos.m_7495_();
        }
        return pos;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.m_128441_("Linked")) {
            this.renderTooltipFromData(tooltip, data);
        } else {
            BlockEntity be;
            BlockState state;
            BlockPos pos = accessor.getPosition();
            BlockPos lowerPos = this.getLowerPos(pos, state = accessor.getBlockState());
            if (!lowerPos.equals((Object)pos) && (be = accessor.getLevel().m_7702_(lowerPos)) instanceof AmenityDoorBlockEntity) {
                AmenityDoorBlockEntity amenityDoor = (AmenityDoorBlockEntity)be;
                this.renderTooltipFromBlockEntity(tooltip, accessor.getLevel(), amenityDoor, state);
                return;
            }
            tooltip.add((Component)Component.m_237113_((String)"Not linked to a hotel").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    private void renderTooltipFromData(ITooltip tooltip, CompoundTag data) {
        if (data.m_128471_("Linked")) {
            String hotelName = data.m_128461_("HotelName");
            String amenityType = data.m_128461_("AmenityType");
            int activeGuests = data.m_128451_("ActiveGuests");
            String header = this.getAmenityHeader(amenityType);
            ChatFormatting color = this.getAmenityColor(amenityType);
            tooltip.add((Component)Component.m_237113_((String)header).m_130944_(new ChatFormatting[]{color, ChatFormatting.BOLD}));
            if (!hotelName.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Hotel: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)hotelName).m_130940_(ChatFormatting.WHITE)));
            }
            tooltip.add((Component)Component.m_237113_((String)"Access: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"Hotel Guests Only").m_130940_(ChatFormatting.YELLOW)));
            if (activeGuests > 0) {
                tooltip.add((Component)Component.m_237113_((String)"Active Guests: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(activeGuests)).m_130940_(ChatFormatting.GREEN)));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Not linked to a hotel").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    private void renderTooltipFromBlockEntity(ITooltip tooltip, Level level, AmenityDoorBlockEntity amenityDoor, BlockState state) {
        BlockEntity controllerBE;
        if (amenityDoor.isLinked() && (controllerBE = level.m_7702_(amenityDoor.getLinkedControllerPos())) instanceof HotelControllerBlockEntity) {
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBE;
            String amenityType = "";
            Block block = state.m_60734_();
            if (block instanceof BaseAmenityDoorBlock) {
                BaseAmenityDoorBlock amenityBlock = (BaseAmenityDoorBlock)block;
                amenityType = amenityBlock.getAmenityType();
            }
            String header = this.getAmenityHeader(amenityType);
            ChatFormatting color = this.getAmenityColor(amenityType);
            tooltip.add((Component)Component.m_237113_((String)header).m_130944_(new ChatFormatting[]{color, ChatFormatting.BOLD}));
            tooltip.add((Component)Component.m_237113_((String)"Hotel: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)controller.getHotelName()).m_130940_(ChatFormatting.WHITE)));
            tooltip.add((Component)Component.m_237113_((String)"Access: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"Hotel Guests Only").m_130940_(ChatFormatting.YELLOW)));
            long activeGuests = controller.getAllRooms().stream().filter(room -> room.isRented()).count();
            if (activeGuests > 0L) {
                tooltip.add((Component)Component.m_237113_((String)"Active Guests: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(activeGuests)).m_130940_(ChatFormatting.GREEN)));
            }
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)"Not linked to a hotel").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }

    private String getAmenityHeader(String amenityType) {
        return switch (amenityType.toLowerCase()) {
            case "pool" -> "POOL ACCESS";
            case "gym" -> "GYM ACCESS";
            case "spa" -> "SPA ACCESS";
            case "restaurant" -> "RESTAURANT ACCESS";
            case "lounge" -> "LOUNGE ACCESS";
            case "conference" -> "CONFERENCE ACCESS";
            case "parking" -> "PARKING ACCESS";
            case "rooftop" -> "ROOFTOP ACCESS";
            default -> "AMENITY ACCESS";
        };
    }

    private ChatFormatting getAmenityColor(String amenityType) {
        return switch (amenityType.toLowerCase()) {
            case "pool" -> ChatFormatting.AQUA;
            case "gym" -> ChatFormatting.RED;
            case "spa" -> ChatFormatting.LIGHT_PURPLE;
            case "restaurant" -> ChatFormatting.GOLD;
            case "lounge" -> ChatFormatting.DARK_PURPLE;
            case "conference" -> ChatFormatting.BLUE;
            case "parking" -> ChatFormatting.GRAY;
            case "rooftop" -> ChatFormatting.GREEN;
            default -> ChatFormatting.WHITE;
        };
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity be = accessor.getBlockEntity();
        if (be instanceof AmenityDoorBlockEntity) {
            AmenityDoorBlockEntity amenityDoor = (AmenityDoorBlockEntity)be;
            if (amenityDoor.isLinked()) {
                BlockEntity controllerBE;
                data.m_128379_("Linked", true);
                BlockState state = accessor.getBlockState();
                Block block = state.m_60734_();
                if (block instanceof BaseAmenityDoorBlock) {
                    BaseAmenityDoorBlock amenityBlock = (BaseAmenityDoorBlock)block;
                    data.m_128359_("AmenityType", amenityBlock.getAmenityType());
                }
                if ((controllerBE = accessor.getLevel().m_7702_(amenityDoor.getLinkedControllerPos())) instanceof HotelControllerBlockEntity) {
                    HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBE;
                    data.m_128359_("HotelName", controller.getHotelName());
                    long activeGuests = controller.getAllRooms().stream().filter(room -> room.isRented()).count();
                    data.m_128405_("ActiveGuests", (int)activeGuests);
                }
            } else {
                data.m_128379_("Linked", false);
            }
        }
    }

    public ResourceLocation getUid() {
        return LCHotelsJadePlugin.AMENITY_DOOR;
    }
}

