/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.compat.jade;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.compat.jade.LCHotelsJadePlugin;
import com.lchotels.util.MoneyUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum HotelControllerComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.m_128441_("HotelName")) {
            String hotelName = data.m_128461_("HotelName");
            String ownerName = data.m_128461_("OwnerName");
            int totalRooms = data.m_128451_("TotalRooms");
            int availableRooms = data.m_128451_("AvailableRooms");
            long storedMoney = data.m_128454_("StoredMoney");
            tooltip.add((Component)Component.m_237113_((String)hotelName).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            if (!ownerName.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Owner: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ownerName).m_130940_(ChatFormatting.WHITE)));
            }
            tooltip.add((Component)Component.m_237113_((String)"Rooms: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(availableRooms + "/" + totalRooms + " available")).m_130940_(availableRooms > 0 ? ChatFormatting.GREEN : ChatFormatting.RED)));
            if (data.m_128471_("IsOwner") && storedMoney > 0L) {
                tooltip.add((Component)Component.m_237113_((String)"Bank: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)MoneyUtil.formatMoney(storedMoney)).m_130940_(ChatFormatting.GOLD)));
            }
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity be = accessor.getBlockEntity();
        if (be instanceof HotelControllerBlockEntity) {
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            data.m_128359_("HotelName", controller.getHotelName());
            data.m_128359_("OwnerName", controller.getOwnerName());
            int totalRooms = controller.getAllRooms().size();
            int availableRooms = controller.getAvailableRooms().size();
            data.m_128405_("TotalRooms", totalRooms);
            data.m_128405_("AvailableRooms", availableRooms);
            data.m_128356_("StoredMoney", controller.getStoredMoney());
            boolean isOwner = controller.isOwner(accessor.getPlayer());
            data.m_128379_("IsOwner", isOwner);
        }
    }

    public ResourceLocation getUid() {
        return LCHotelsJadePlugin.HOTEL_CONTROLLER;
    }
}

