/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.compat.jade;

import com.lchotels.block.KeycardDoorBlock;
import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.blockentity.KeycardDoorBlockEntity;
import com.lchotels.compat.jade.LCHotelsJadePlugin;
import com.lchotels.data.RoomData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum KeycardDoorComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    private BlockPos getLowerPos(BlockPos pos, BlockState state) {
        if (state.m_61138_(KeycardDoorBlock.HALF) && state.m_61143_(KeycardDoorBlock.HALF) == DoubleBlockHalf.UPPER) {
            return pos.m_7495_();
        }
        return pos;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.m_128441_("Linked")) {
            this.renderTooltipFromData(tooltip, data);
        } else {
            BlockEntity be;
            BlockState state;
            BlockPos pos = accessor.getPosition();
            BlockPos lowerPos = this.getLowerPos(pos, state = accessor.getBlockState());
            if (!lowerPos.equals((Object)pos) && (be = accessor.getLevel().m_7702_(lowerPos)) instanceof KeycardDoorBlockEntity) {
                KeycardDoorBlockEntity doorEntity = (KeycardDoorBlockEntity)be;
                this.renderTooltipFromBlockEntity(tooltip, accessor.getLevel(), doorEntity);
                return;
            }
            tooltip.add((Component)Component.m_237113_((String)"Not linked to a room").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    private void renderTooltipFromData(ITooltip tooltip, CompoundTag data) {
        if (data.m_128471_("Linked")) {
            String roomName = data.m_128461_("RoomName");
            String hotelName = data.m_128461_("HotelName");
            if (!hotelName.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Hotel: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)hotelName).m_130940_(ChatFormatting.WHITE)));
            }
            if (!roomName.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Room: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)roomName).m_130940_(ChatFormatting.GOLD)));
            }
            if (data.m_128441_("Occupied") && data.m_128471_("Occupied")) {
                String guestName = data.m_128461_("GuestName");
                int daysLeft = data.m_128451_("DaysLeft");
                tooltip.add((Component)Component.m_237113_((String)"Status: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"Occupied").m_130940_(ChatFormatting.RED)));
                if (!guestName.isEmpty()) {
                    tooltip.add((Component)Component.m_237113_((String)"Guest: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)guestName).m_130940_(ChatFormatting.GREEN)));
                }
                if (daysLeft > 0) {
                    ChatFormatting color = daysLeft <= 1 ? ChatFormatting.RED : (daysLeft <= 3 ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
                    tooltip.add((Component)Component.m_237113_((String)"Time Left: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(daysLeft + " day(s)")).m_130940_(color)));
                }
            } else {
                tooltip.add((Component)Component.m_237113_((String)"Status: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"Available").m_130940_(ChatFormatting.GREEN)));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Not linked to a room").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    private void renderTooltipFromBlockEntity(ITooltip tooltip, Level level, KeycardDoorBlockEntity doorEntity) {
        if (doorEntity.isLinked()) {
            String roomId = doorEntity.getLinkedRoomId();
            BlockEntity controllerBE = level.m_7702_(doorEntity.getLinkedControllerPos());
            if (controllerBE instanceof HotelControllerBlockEntity) {
                RoomData room;
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBE;
                String hotelName = controller.getHotelName();
                if (!hotelName.isEmpty()) {
                    tooltip.add((Component)Component.m_237113_((String)"Hotel: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)hotelName).m_130940_(ChatFormatting.WHITE)));
                }
                if ((room = controller.getRoom(roomId)) != null) {
                    tooltip.add((Component)Component.m_237113_((String)"Room: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)room.getRoomName()).m_130940_(ChatFormatting.GOLD)));
                    if (room.isRented()) {
                        int daysLeft;
                        tooltip.add((Component)Component.m_237113_((String)"Status: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"Occupied").m_130940_(ChatFormatting.RED)));
                        String guestName = room.getCurrentGuestName();
                        if (!guestName.isEmpty()) {
                            tooltip.add((Component)Component.m_237113_((String)"Guest: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)guestName).m_130940_(ChatFormatting.GREEN)));
                        }
                        if ((daysLeft = room.getRemainingDays(level)) > 0) {
                            ChatFormatting color = daysLeft <= 1 ? ChatFormatting.RED : (daysLeft <= 3 ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
                            tooltip.add((Component)Component.m_237113_((String)"Time Left: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(daysLeft + " day(s)")).m_130940_(color)));
                        }
                    } else {
                        tooltip.add((Component)Component.m_237113_((String)"Status: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"Available").m_130940_(ChatFormatting.GREEN)));
                    }
                    return;
                }
            }
        }
        tooltip.add((Component)Component.m_237113_((String)"Not linked to a room").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity be = accessor.getBlockEntity();
        if (be instanceof KeycardDoorBlockEntity) {
            KeycardDoorBlockEntity doorEntity = (KeycardDoorBlockEntity)be;
            if (doorEntity.isLinked()) {
                data.m_128379_("Linked", true);
                String roomId = doorEntity.getLinkedRoomId();
                data.m_128359_("RoomId", roomId);
                BlockEntity controllerBE = accessor.getLevel().m_7702_(doorEntity.getLinkedControllerPos());
                if (controllerBE instanceof HotelControllerBlockEntity) {
                    HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBE;
                    data.m_128359_("HotelName", controller.getHotelName());
                    RoomData room = controller.getRoom(roomId);
                    if (room != null) {
                        data.m_128359_("RoomName", room.getRoomName());
                        data.m_128379_("Occupied", room.isRented());
                        if (room.isRented()) {
                            data.m_128359_("GuestName", room.getCurrentGuestName());
                            data.m_128405_("DaysLeft", room.getRemainingDays(accessor.getLevel()));
                        }
                    }
                }
            } else {
                data.m_128379_("Linked", false);
            }
        }
    }

    public ResourceLocation getUid() {
        return LCHotelsJadePlugin.KEYCARD_DOOR;
    }
}

