/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class LCHotelsConfig {
    public static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec.IntValue MAX_RENTAL_DAYS;
    public static final ForgeConfigSpec.IntValue MIN_RENTAL_DAYS;
    public static final ForgeConfigSpec.BooleanValue ALLOW_EARLY_CHECKOUT_REFUND;
    public static final ForgeConfigSpec.DoubleValue EARLY_CHECKOUT_REFUND_PERCENT;
    public static final ForgeConfigSpec.IntValue KEYCARD_DOOR_RANGE;
    public static final ForgeConfigSpec.BooleanValue OWNERS_RECEIVE_PAYMENT_IMMEDIATELY;
    public static final ForgeConfigSpec.IntValue TICKS_PER_RENTAL_DAY;
    public static final ForgeConfigSpec.IntValue EXPIRATION_CHECK_INTERVAL;
    public static final ForgeConfigSpec.IntValue EXPIRATION_WARNING_TICKS;
    public static final ForgeConfigSpec.LongValue DEFAULT_ROOM_PRICE;
    public static final ForgeConfigSpec.LongValue MAX_ROOM_PRICE;
    public static final ForgeConfigSpec.IntValue MAX_ROOMS_PER_HOTEL;
    public static final ForgeConfigSpec.IntValue MAX_HOTEL_NAME_LENGTH;
    public static final ForgeConfigSpec.BooleanValue SHOW_RENTAL_NOTIFICATIONS;

    static {
        SERVER_BUILDER.comment("LC Hotels Server Configuration").push("server");
        SERVER_BUILDER.comment("Room Rental Settings").push("rental");
        MIN_RENTAL_DAYS = SERVER_BUILDER.comment("Minimum number of days a room can be rented").defineInRange("minRentalDays", 1, 1, 30);
        MAX_RENTAL_DAYS = SERVER_BUILDER.comment("Maximum number of days a room can be rented at once").defineInRange("maxRentalDays", 30, 1, 365);
        ALLOW_EARLY_CHECKOUT_REFUND = SERVER_BUILDER.comment("Allow guests to check out early and receive a partial refund").define("allowEarlyCheckoutRefund", true);
        EARLY_CHECKOUT_REFUND_PERCENT = SERVER_BUILDER.comment(new String[]{"Percentage of remaining days refunded on early checkout (0.0 - 1.0)", "0.5 = 50% refund, 1.0 = full refund, 0.0 = no refund"}).defineInRange("earlyCheckoutRefundPercent", 0.5, 0.0, 1.0);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Keycard and Door Settings").push("keycard");
        KEYCARD_DOOR_RANGE = SERVER_BUILDER.comment("Maximum distance (in blocks) from hotel controller that keycard doors can be linked").defineInRange("keycardDoorRange", 64, 16, 256);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Payment Settings").push("payment");
        OWNERS_RECEIVE_PAYMENT_IMMEDIATELY = SERVER_BUILDER.comment(new String[]{"If true and owner is online, they receive payment directly.", "If false or owner is offline, payment goes to hotel bank for withdrawal."}).define("ownersReceivePaymentImmediately", false);
        DEFAULT_ROOM_PRICE = SERVER_BUILDER.comment("Default price per day for new rooms (in smallest currency unit, e.g. copper)").defineInRange("defaultRoomPrice", 100L, 1L, 1000000L);
        MAX_ROOM_PRICE = SERVER_BUILDER.comment("Maximum price per day for rooms (in smallest currency unit)").defineInRange("maxRoomPrice", 1000000L, 100L, 100000000L);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Time Settings").push("time");
        TICKS_PER_RENTAL_DAY = SERVER_BUILDER.comment(new String[]{"How many game ticks equal one rental 'day'", "Default 24000 = one Minecraft day", "Set to 1200 for 1 minute per day (for testing)"}).defineInRange("ticksPerRentalDay", 24000, 100, 240000);
        EXPIRATION_CHECK_INTERVAL = SERVER_BUILDER.comment(new String[]{"How often to check for expired rentals (in ticks)", "Default 1200 = every minute"}).defineInRange("expirationCheckInterval", 1200, 20, 6000);
        EXPIRATION_WARNING_TICKS = SERVER_BUILDER.comment(new String[]{"Warn guests when this many ticks remain on their rental", "Default 24000 = warn when less than 1 day remains"}).defineInRange("expirationWarningTicks", 24000, 1000, 72000);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Hotel Settings").push("hotel");
        MAX_ROOMS_PER_HOTEL = SERVER_BUILDER.comment("Maximum number of rooms a single hotel can have").defineInRange("maxRoomsPerHotel", 100, 1, 1000);
        MAX_HOTEL_NAME_LENGTH = SERVER_BUILDER.comment("Maximum length for hotel names").defineInRange("maxHotelNameLength", 32, 8, 64);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.pop();
        SERVER_SPEC = SERVER_BUILDER.build();
        CLIENT_BUILDER.comment("LC Hotels Client Configuration").push("client");
        SHOW_RENTAL_NOTIFICATIONS = CLIENT_BUILDER.comment("Show notifications when rental time is running low").define("showRentalNotifications", true);
        CLIENT_BUILDER.pop();
        CLIENT_SPEC = CLIENT_BUILDER.build();
    }
}

