/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.data;

import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class HotelData
extends SavedData {
    private static final String DATA_NAME = "lchotels_data";
    private final Map<UUID, HotelInfo> hotels = new ConcurrentHashMap<UUID, HotelInfo>();
    private final Map<String, RoomData> allRooms = new ConcurrentHashMap<String, RoomData>();
    private final Map<UUID, Set<String>> playerRentals = new ConcurrentHashMap<UUID, Set<String>>();

    public static HotelData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get HotelData from client level!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        DimensionDataStorage storage = serverLevel.m_8895_();
        return (HotelData)storage.m_164861_(HotelData::load, HotelData::new, DATA_NAME);
    }

    public UUID createHotel(String name, UUID ownerId, String ownerName, BlockPos controllerPos) {
        UUID hotelId = UUID.randomUUID();
        HotelInfo hotel = new HotelInfo(hotelId, name, ownerId, ownerName, controllerPos);
        this.hotels.put(hotelId, hotel);
        this.m_77762_();
        return hotelId;
    }

    public void removeHotel(UUID hotelId) {
        HotelInfo hotel = this.hotels.remove(hotelId);
        if (hotel != null) {
            for (String roomId : hotel.rooms.keySet()) {
                this.allRooms.remove(roomId);
            }
        }
        this.m_77762_();
    }

    public HotelInfo getHotel(UUID hotelId) {
        return this.hotels.get(hotelId);
    }

    public Collection<HotelInfo> getAllHotels() {
        return this.hotels.values();
    }

    public RoomData createRoom(UUID hotelId, String roomNumber, RoomType type, long pricePerDay) {
        HotelInfo hotel = this.hotels.get(hotelId);
        if (hotel == null) {
            return null;
        }
        String fullRoomId = hotelId.toString().substring(0, 8) + "_" + roomNumber;
        RoomData room = new RoomData(fullRoomId);
        room.setRoomName("Room " + roomNumber);
        room.setRoomType(type);
        room.setPricePerDay(pricePerDay);
        room.setControllerPos(hotel.controllerPos);
        hotel.rooms.put(fullRoomId, room);
        this.allRooms.put(fullRoomId, room);
        this.m_77762_();
        return room;
    }

    public void removeRoom(UUID hotelId, String roomId) {
        HotelInfo hotel = this.hotels.get(hotelId);
        if (hotel != null) {
            hotel.rooms.remove(roomId);
            this.allRooms.remove(roomId);
            this.m_77762_();
        }
    }

    public RoomData getRoom(String roomId) {
        return this.allRooms.get(roomId);
    }

    public List<RoomData> getAvailableRooms(UUID hotelId) {
        HotelInfo hotel = this.hotels.get(hotelId);
        if (hotel == null) {
            return Collections.emptyList();
        }
        ArrayList<RoomData> available = new ArrayList<RoomData>();
        for (RoomData room : hotel.rooms.values()) {
            if (!room.isAvailable()) continue;
            available.add(room);
        }
        return available;
    }

    public List<RoomData> getRoomsByType(UUID hotelId, RoomType type) {
        HotelInfo hotel = this.hotels.get(hotelId);
        if (hotel == null) {
            return Collections.emptyList();
        }
        ArrayList<RoomData> rooms = new ArrayList<RoomData>();
        for (RoomData room : hotel.rooms.values()) {
            if (room.getRoomType() != type) continue;
            rooms.add(room);
        }
        return rooms;
    }

    public boolean rentRoom(String roomId, UUID guestId, String guestName, int days, Level level) {
        RoomData room = this.allRooms.get(roomId);
        if (room == null || !room.isAvailable()) {
            return false;
        }
        room.rentRoom(guestId, guestName, days, level);
        this.playerRentals.computeIfAbsent(guestId, k -> new HashSet()).add(roomId);
        this.m_77762_();
        return true;
    }

    public long checkOutRoom(String roomId, Level level, boolean earlyCheckout) {
        Set<String> rentals;
        UUID guestId;
        RoomData room = this.allRooms.get(roomId);
        if (room == null || !room.isRented()) {
            return 0L;
        }
        long refund = 0L;
        if (earlyCheckout && room.getRemainingDays(level) > 0) {
            refund = (long)((double)(room.getPricePerDay() * (long)room.getRemainingDays(level)) * 0.5);
        }
        if ((guestId = room.getCurrentGuest()) != null && (rentals = this.playerRentals.get(guestId)) != null) {
            rentals.remove(roomId);
        }
        room.checkOut();
        this.m_77762_();
        return refund;
    }

    public Set<String> getPlayerRentals(UUID playerId) {
        return this.playerRentals.getOrDefault(playerId, Collections.emptySet());
    }

    public void checkExpiredRentals(Level level) {
        for (RoomData room : this.allRooms.values()) {
            if (!room.isRented() || !room.isRentalExpired(level)) continue;
            this.checkOutRoom(room.getRoomId(), level, false);
        }
    }

    public HotelInfo getHotelByController(BlockPos pos) {
        for (HotelInfo hotel : this.hotels.values()) {
            if (!hotel.controllerPos.equals((Object)pos)) continue;
            return hotel;
        }
        return null;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag hotelsList = new ListTag();
        for (HotelInfo hotel : this.hotels.values()) {
            hotelsList.add((Object)hotel.save());
        }
        tag.m_128365_("Hotels", (Tag)hotelsList);
        ListTag rentalsList = new ListTag();
        for (Map.Entry<UUID, Set<String>> entry : this.playerRentals.entrySet()) {
            CompoundTag rentalTag = new CompoundTag();
            rentalTag.m_128362_("PlayerId", entry.getKey());
            ListTag roomIdsList = new ListTag();
            for (String roomId : entry.getValue()) {
                CompoundTag roomIdTag = new CompoundTag();
                roomIdTag.m_128359_("RoomId", roomId);
                roomIdsList.add((Object)roomIdTag);
            }
            rentalTag.m_128365_("RoomIds", (Tag)roomIdsList);
            rentalsList.add((Object)rentalTag);
        }
        tag.m_128365_("PlayerRentals", (Tag)rentalsList);
        return tag;
    }

    public static HotelData load(CompoundTag tag) {
        int i;
        HotelData data = new HotelData();
        if (tag.m_128441_("Hotels")) {
            ListTag hotelsList = tag.m_128437_("Hotels", 10);
            for (i = 0; i < hotelsList.size(); ++i) {
                HotelInfo hotel = HotelInfo.load(hotelsList.m_128728_(i));
                data.hotels.put(hotel.hotelId, hotel);
                for (RoomData room : hotel.rooms.values()) {
                    data.allRooms.put(room.getRoomId(), room);
                }
            }
        }
        if (tag.m_128441_("PlayerRentals")) {
            ListTag rentalsList = tag.m_128437_("PlayerRentals", 10);
            for (i = 0; i < rentalsList.size(); ++i) {
                CompoundTag rentalTag = rentalsList.m_128728_(i);
                UUID playerId = rentalTag.m_128342_("PlayerId");
                HashSet<String> roomIds = new HashSet<String>();
                ListTag roomIdsList = rentalTag.m_128437_("RoomIds", 10);
                for (int j = 0; j < roomIdsList.size(); ++j) {
                    roomIds.add(roomIdsList.m_128728_(j).m_128461_("RoomId"));
                }
                data.playerRentals.put(playerId, roomIds);
            }
        }
        return data;
    }

    public static class HotelInfo {
        public UUID hotelId;
        public String hotelName;
        public UUID ownerId;
        public String ownerName;
        public BlockPos controllerPos;
        public Map<String, RoomData> rooms = new HashMap<String, RoomData>();
        public long totalRevenue;
        public long pendingPayments;

        public HotelInfo(UUID hotelId, String hotelName, UUID ownerId, String ownerName, BlockPos pos) {
            this.hotelId = hotelId;
            this.hotelName = hotelName;
            this.ownerId = ownerId;
            this.ownerName = ownerName;
            this.controllerPos = pos;
            this.totalRevenue = 0L;
            this.pendingPayments = 0L;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("HotelId", this.hotelId);
            tag.m_128359_("HotelName", this.hotelName);
            tag.m_128362_("OwnerId", this.ownerId);
            tag.m_128359_("OwnerName", this.ownerName);
            tag.m_128356_("ControllerX", (long)this.controllerPos.m_123341_());
            tag.m_128356_("ControllerY", (long)this.controllerPos.m_123342_());
            tag.m_128356_("ControllerZ", (long)this.controllerPos.m_123343_());
            tag.m_128356_("TotalRevenue", this.totalRevenue);
            tag.m_128356_("PendingPayments", this.pendingPayments);
            ListTag roomsList = new ListTag();
            for (RoomData room : this.rooms.values()) {
                roomsList.add((Object)room.save());
            }
            tag.m_128365_("Rooms", (Tag)roomsList);
            return tag;
        }

        public static HotelInfo load(CompoundTag tag) {
            HotelInfo info = new HotelInfo(tag.m_128342_("HotelId"), tag.m_128461_("HotelName"), tag.m_128342_("OwnerId"), tag.m_128461_("OwnerName"), new BlockPos((int)tag.m_128454_("ControllerX"), (int)tag.m_128454_("ControllerY"), (int)tag.m_128454_("ControllerZ")));
            info.totalRevenue = tag.m_128454_("TotalRevenue");
            info.pendingPayments = tag.m_128454_("PendingPayments");
            if (tag.m_128441_("Rooms")) {
                ListTag roomsList = tag.m_128437_("Rooms", 10);
                for (int i = 0; i < roomsList.size(); ++i) {
                    RoomData room = RoomData.load(roomsList.m_128728_(i));
                    info.rooms.put(room.getRoomId(), room);
                }
            }
            return info;
        }
    }
}

