/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.data;

import com.lchotels.config.LCHotelsConfig;
import com.lchotels.data.RoomType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class RoomData {
    private String roomId;
    private String roomName;
    private RoomType roomType;
    private UUID currentGuest;
    private String currentGuestName;
    private long rentalStartTime;
    private long rentalEndTime;
    private int daysRented;
    private long pricePerDay;
    private Set<BlockPos> linkedDoors;
    private BlockPos controllerPos;
    private boolean isAvailable;

    public RoomData(String roomId) {
        this.roomId = roomId;
        this.roomName = "Room " + roomId;
        this.roomType = RoomType.STANDARD;
        this.currentGuest = null;
        this.currentGuestName = "";
        this.rentalStartTime = 0L;
        this.rentalEndTime = 0L;
        this.daysRented = 0;
        this.pricePerDay = (Long)LCHotelsConfig.DEFAULT_ROOM_PRICE.get();
        this.linkedDoors = new HashSet<BlockPos>();
        this.controllerPos = BlockPos.f_121853_;
        this.isAvailable = true;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(RoomType roomType) {
        this.roomType = roomType;
    }

    @Nullable
    public UUID getCurrentGuest() {
        return this.currentGuest;
    }

    public void setCurrentGuest(@Nullable UUID currentGuest) {
        this.currentGuest = currentGuest;
    }

    public String getCurrentGuestName() {
        return this.currentGuestName;
    }

    public void setCurrentGuestName(String currentGuestName) {
        this.currentGuestName = currentGuestName;
    }

    public long getRentalStartTime() {
        return this.rentalStartTime;
    }

    public void setRentalStartTime(long rentalStartTime) {
        this.rentalStartTime = rentalStartTime;
    }

    public long getRentalEndTime() {
        return this.rentalEndTime;
    }

    public void setRentalEndTime(long rentalEndTime) {
        this.rentalEndTime = rentalEndTime;
    }

    public int getDaysRented() {
        return this.daysRented;
    }

    public void setDaysRented(int daysRented) {
        this.daysRented = daysRented;
    }

    public long getPricePerDay() {
        return this.pricePerDay;
    }

    public void setPricePerDay(long pricePerDay) {
        this.pricePerDay = pricePerDay;
    }

    public Set<BlockPos> getLinkedDoors() {
        return this.linkedDoors;
    }

    public void addLinkedDoor(BlockPos pos) {
        this.linkedDoors.add(pos);
    }

    public void removeLinkedDoor(BlockPos pos) {
        this.linkedDoors.remove(pos);
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailable(boolean available) {
        this.isAvailable = available;
    }

    public boolean isRented() {
        return this.currentGuest != null;
    }

    public boolean isRentalExpired(Level level) {
        if (!this.isRented()) {
            return false;
        }
        return level.m_46467_() >= this.rentalEndTime;
    }

    public long getRemainingTime(Level level) {
        if (!this.isRented()) {
            return 0L;
        }
        return Math.max(0L, this.rentalEndTime - level.m_46467_());
    }

    public int getRemainingDays(Level level) {
        long remaining = this.getRemainingTime(level);
        int ticksPerDay = (Integer)LCHotelsConfig.TICKS_PER_RENTAL_DAY.get();
        return (int)Math.ceil((double)remaining / (double)ticksPerDay);
    }

    public long getTotalPrice() {
        return this.pricePerDay * (long)this.daysRented;
    }

    public void rentRoom(UUID guest, String guestName, int days, Level level) {
        int ticksPerDay = (Integer)LCHotelsConfig.TICKS_PER_RENTAL_DAY.get();
        this.rentRoomWithCustomDay(guest, guestName, days, level, ticksPerDay);
    }

    public void rentRoomWithCustomDay(UUID guest, String guestName, int days, Level level, int ticksPerDay) {
        this.currentGuest = guest;
        this.currentGuestName = guestName;
        this.daysRented = days;
        this.rentalStartTime = level.m_46467_();
        this.rentalEndTime = this.rentalStartTime + (long)days * (long)ticksPerDay;
        this.isAvailable = false;
    }

    public void checkOut() {
        this.currentGuest = null;
        this.currentGuestName = "";
        this.rentalStartTime = 0L;
        this.rentalEndTime = 0L;
        this.daysRented = 0;
        this.isAvailable = true;
    }

    public void extendRental(int additionalDays) {
        int ticksPerDay = (Integer)LCHotelsConfig.TICKS_PER_RENTAL_DAY.get();
        this.daysRented += additionalDays;
        this.rentalEndTime += (long)additionalDays * (long)ticksPerDay;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("RoomId", this.roomId);
        tag.m_128359_("RoomName", this.roomName);
        tag.m_128359_("RoomType", this.roomType.m_7912_());
        if (this.currentGuest != null) {
            tag.m_128362_("CurrentGuest", this.currentGuest);
            tag.m_128359_("CurrentGuestName", this.currentGuestName);
        }
        tag.m_128356_("RentalStartTime", this.rentalStartTime);
        tag.m_128356_("RentalEndTime", this.rentalEndTime);
        tag.m_128405_("DaysRented", this.daysRented);
        tag.m_128356_("PricePerDay", this.pricePerDay);
        tag.m_128379_("IsAvailable", this.isAvailable);
        if (this.controllerPos != BlockPos.f_121853_) {
            tag.m_128365_("ControllerPos", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        ListTag doorsList = new ListTag();
        for (BlockPos pos : this.linkedDoors) {
            doorsList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        tag.m_128365_("LinkedDoors", (Tag)doorsList);
        return tag;
    }

    public static RoomData load(CompoundTag tag) {
        RoomData data = new RoomData(tag.m_128461_("RoomId"));
        data.roomName = tag.m_128461_("RoomName");
        data.roomType = RoomType.fromString(tag.m_128461_("RoomType"));
        if (tag.m_128441_("CurrentGuest")) {
            data.currentGuest = tag.m_128342_("CurrentGuest");
            data.currentGuestName = tag.m_128461_("CurrentGuestName");
        }
        data.rentalStartTime = tag.m_128454_("RentalStartTime");
        data.rentalEndTime = tag.m_128454_("RentalEndTime");
        data.daysRented = tag.m_128451_("DaysRented");
        data.pricePerDay = tag.m_128454_("PricePerDay");
        data.isAvailable = tag.m_128471_("IsAvailable");
        if (tag.m_128441_("ControllerPos")) {
            data.controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPos"));
        }
        if (tag.m_128441_("LinkedDoors")) {
            ListTag doorsList = tag.m_128437_("LinkedDoors", 10);
            for (int i = 0; i < doorsList.size(); ++i) {
                data.linkedDoors.add(NbtUtils.m_129239_((CompoundTag)doorsList.m_128728_(i)));
            }
        }
        return data;
    }
}

