/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.data;

import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public enum RoomType implements StringRepresentable
{
    STANDARD("standard", "Standard Room"),
    DELUXE("deluxe", "Deluxe Room"),
    SUITE("suite", "Suite"),
    PENTHOUSE("penthouse", "Penthouse"),
    CONFERENCE_SMALL("conference_small", "Small Conference Room"),
    CONFERENCE_MEDIUM("conference_medium", "Medium Conference Room"),
    CONFERENCE_LARGE("conference_large", "Large Conference Room"),
    BALLROOM("ballroom", "Ballroom");

    private final String name;
    private final String displayName;

    private RoomType(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public String m_7912_() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Component getDisplayComponent() {
        return Component.m_237115_((String)("lchotels.room_type." + this.name));
    }

    public boolean isConferenceRoom() {
        return this == CONFERENCE_SMALL || this == CONFERENCE_MEDIUM || this == CONFERENCE_LARGE || this == BALLROOM;
    }

    public static RoomType fromString(String name) {
        for (RoomType type : RoomType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return STANDARD;
    }
}

