/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.item;

import com.lchotels.blockentity.KeycardDoorBlockEntity;
import com.lchotels.config.LCHotelsConfig;
import com.lchotels.init.ModItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class KeycardItem
extends Item {
    public KeycardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof KeycardDoorBlockEntity) {
            BlockPos controllerPos;
            String roomId;
            KeycardDoorBlockEntity door = (KeycardDoorBlockEntity)be;
            if (context.m_43723_() != null && context.m_43723_().m_6144_() && !(roomId = KeycardItem.getRoomId(stack)).isEmpty() && !(controllerPos = KeycardItem.getControllerPos(stack)).equals((Object)BlockPos.f_121853_)) {
                door.linkToRoom(roomId, controllerPos);
                context.m_43723_().m_5661_((Component)Component.m_237110_((String)"lchotels.keycard.door_linked", (Object[])new Object[]{KeycardItem.getRoomName(stack)}), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        String hotelName = tag.m_128461_("HotelName");
        String roomName = tag.m_128461_("RoomName");
        String guestName = tag.m_128461_("GuestName");
        long expirationTime = tag.m_128454_("ExpirationTime");
        if (!hotelName.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)"Hotel: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)hotelName).m_130940_(ChatFormatting.WHITE)));
        }
        if (!roomName.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)"Room: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)roomName).m_130940_(ChatFormatting.GOLD)));
        }
        if (!guestName.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)"Guest: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)guestName).m_130940_(ChatFormatting.GREEN)));
        }
        if (expirationTime > 0L && level != null) {
            long remaining = expirationTime - level.m_46467_();
            if (remaining > 0L) {
                String timeText = this.formatRemainingTime(remaining);
                ChatFormatting color = this.getTimeColor(remaining);
                tooltip.add((Component)Component.m_237113_((String)"Expires in: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)timeText).m_130940_(color)));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"EXPIRED").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            }
        }
    }

    private String formatRemainingTime(long remainingTicks) {
        int ticksPerDay = (Integer)LCHotelsConfig.TICKS_PER_RENTAL_DAY.get();
        int totalMinutes = (int)(remainingTicks / 20L / 60L);
        int totalHours = totalMinutes / 60;
        int days = (int)Math.ceil((double)remainingTicks / (double)ticksPerDay);
        if (remainingTicks < (long)ticksPerDay) {
            int seconds;
            int hours = totalHours;
            int minutes = totalMinutes % 60;
            if (hours > 0) {
                if (minutes > 0) {
                    return hours + "h " + minutes + "m";
                }
                return hours + " hour" + (hours != 1 ? "s" : "");
            }
            if (minutes > 0) {
                return minutes + " minute" + (minutes != 1 ? "s" : "");
            }
            return seconds + " second" + ((seconds = (int)(remainingTicks / 20L)) != 1 ? "s" : "");
        }
        if (days == 1) {
            int hoursLeft = (int)(remainingTicks / 20L / 60L / 60L);
            if (hoursLeft > 0 && hoursLeft < 24) {
                return "1 day (" + hoursLeft + "h)";
            }
            return "1 day";
        }
        return days + " days";
    }

    private ChatFormatting getTimeColor(long remainingTicks) {
        int ticksPerDay = (Integer)LCHotelsConfig.TICKS_PER_RENTAL_DAY.get();
        if (remainingTicks < (long)ticksPerDay) {
            return ChatFormatting.RED;
        }
        if (remainingTicks < (long)(ticksPerDay * 3)) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("ExpirationTime")) {
            long l = tag.m_128454_("ExpirationTime");
        }
        return false;
    }

    public static String getRoomId(ItemStack stack) {
        return stack.m_41784_().m_128461_("RoomId");
    }

    public static String getRoomName(ItemStack stack) {
        return stack.m_41784_().m_128461_("RoomName");
    }

    public static BlockPos getControllerPos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("ControllerPos")) {
            return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPos"));
        }
        return BlockPos.f_121853_;
    }

    public static UUID getGuestId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("GuestId")) {
            return tag.m_128342_("GuestId");
        }
        return null;
    }

    public static ItemStack createKeycard(String hotelName, String roomId, String roomName, UUID guestId, String guestName, long expirationTime, BlockPos controllerPos) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.KEYCARD.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("HotelName", hotelName);
        tag.m_128359_("RoomId", roomId);
        tag.m_128359_("RoomName", roomName);
        tag.m_128362_("GuestId", guestId);
        tag.m_128359_("GuestName", guestName);
        tag.m_128356_("ExpirationTime", expirationTime);
        tag.m_128365_("ControllerPos", (Tag)NbtUtils.m_129224_((BlockPos)controllerPos));
        return stack;
    }
}

