/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.item;

import com.lchotels.block.BaseAmenityDoorBlock;
import com.lchotels.block.ConferenceDoorBlock;
import com.lchotels.block.FrontDeskBlock;
import com.lchotels.block.KeycardDoorBlock;
import com.lchotels.blockentity.AmenityDoorBlockEntity;
import com.lchotels.blockentity.ConferenceDoorBlockEntity;
import com.lchotels.blockentity.FrontDeskBlockEntity;
import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.blockentity.KeycardDoorBlockEntity;
import com.lchotels.data.RoomData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;

public class RoomLinkerItem
extends Item {
    public RoomLinkerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos lowerPos;
        Block doorBe;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (level.m_5776_() || player == null) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        BlockState state = level.m_8055_(pos);
        CompoundTag tag = stack.m_41784_();
        if (be instanceof HotelControllerBlockEntity) {
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.isOwner(player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.not_owner").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            if (player.m_6144_()) {
                tag.m_128365_("ControllerPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                tag.m_128359_("HotelName", controller.getHotelName());
                tag.m_128473_("RoomId");
                tag.m_128473_("RoomName");
                tag.m_128473_("IsConferenceRoom");
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.linker.controller_selected", (Object[])new Object[]{controller.getHotelName()}).m_130940_(ChatFormatting.GREEN), true);
                return InteractionResult.SUCCESS;
            }
        }
        if (state.m_60734_() instanceof FrontDeskBlock && be instanceof FrontDeskBlockEntity) {
            FrontDeskBlockEntity frontDesk = (FrontDeskBlockEntity)be;
            return this.handleFrontDeskLink(level, player, stack, tag, frontDesk);
        }
        if (state.m_60734_() instanceof ConferenceDoorBlock && (doorBe = level.m_7702_(lowerPos = state.m_61143_(ConferenceDoorBlock.HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_())) instanceof ConferenceDoorBlockEntity) {
            ConferenceDoorBlockEntity doorEntity = (ConferenceDoorBlockEntity)doorBe;
            return this.handleConferenceDoorLink(level, player, stack, tag, doorEntity, lowerPos);
        }
        doorBe = state.m_60734_();
        if (doorBe instanceof BaseAmenityDoorBlock) {
            BaseAmenityDoorBlock amenityBlock = (BaseAmenityDoorBlock)doorBe;
            BlockPos lowerPos2 = state.m_61143_(BaseAmenityDoorBlock.HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
            BlockEntity doorBe2 = level.m_7702_(lowerPos2);
            if (doorBe2 instanceof AmenityDoorBlockEntity) {
                AmenityDoorBlockEntity amenityDoor = (AmenityDoorBlockEntity)doorBe2;
                return this.handleAmenityDoorLink(level, player, stack, tag, amenityDoor, lowerPos2, amenityBlock.getAmenityType());
            }
        }
        if (state.m_60734_() instanceof KeycardDoorBlock && (doorBe = level.m_7702_(lowerPos = state.m_61143_(KeycardDoorBlock.HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_())) instanceof KeycardDoorBlockEntity) {
            KeycardDoorBlockEntity doorEntity = (KeycardDoorBlockEntity)doorBe;
            return this.handleKeycardDoorLink(level, player, stack, tag, doorEntity, lowerPos);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleFrontDeskLink(Level level, Player player, ItemStack stack, CompoundTag tag, FrontDeskBlockEntity frontDesk) {
        if (tag.m_128441_("ControllerPos")) {
            BlockPos controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPos"));
            BlockEntity controllerBe = level.m_7702_(controllerPos);
            if (controllerBe instanceof HotelControllerBlockEntity) {
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBe;
                if (!controller.isOwner(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.not_owner").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                frontDesk.linkToController(controllerPos);
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.linker.front_desk_linked", (Object[])new Object[]{controller.getHotelName()}).m_130940_(ChatFormatting.GREEN), true);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.controller_not_found").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.select_controller_first").m_130940_(ChatFormatting.YELLOW), true);
        return InteractionResult.FAIL;
    }

    private InteractionResult handleAmenityDoorLink(Level level, Player player, ItemStack stack, CompoundTag tag, AmenityDoorBlockEntity amenityDoor, BlockPos lowerPos, String amenityType) {
        if (tag.m_128441_("ControllerPos")) {
            BlockPos controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPos"));
            BlockEntity controllerBe = level.m_7702_(controllerPos);
            if (controllerBe instanceof HotelControllerBlockEntity) {
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBe;
                if (!controller.isOwner(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.not_owner").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                if (!controller.isDoorInRange(lowerPos)) {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.door_out_of_range").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                amenityDoor.linkToHotel(controllerPos);
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.linker.amenity_door_linked", (Object[])new Object[]{amenityType, controller.getHotelName()}).m_130940_(ChatFormatting.GREEN), true);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.controller_not_found").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.select_controller_first").m_130940_(ChatFormatting.YELLOW), true);
        return InteractionResult.FAIL;
    }

    private InteractionResult handleConferenceDoorLink(Level level, Player player, ItemStack stack, CompoundTag tag, ConferenceDoorBlockEntity doorEntity, BlockPos lowerPos) {
        if (tag.m_128441_("RoomId") && tag.m_128441_("ControllerPos")) {
            String roomId = tag.m_128461_("RoomId");
            boolean isConferenceRoom = tag.m_128471_("IsConferenceRoom");
            BlockPos controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPos"));
            if (!isConferenceRoom) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.conference_door_wrong_type").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            BlockEntity controllerBe = level.m_7702_(controllerPos);
            if (controllerBe instanceof HotelControllerBlockEntity) {
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBe;
                if (!controller.isOwner(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.not_owner").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                if (!controller.isDoorInRange(lowerPos)) {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.door_out_of_range").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                doorEntity.linkToRoom(roomId, controllerPos);
                controller.linkDoor(lowerPos);
                RoomData room = controller.getRoom(roomId);
                if (room != null) {
                    room.addLinkedDoor(lowerPos);
                }
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.linker.door_linked", (Object[])new Object[]{tag.m_128461_("RoomName")}).m_130940_(ChatFormatting.GREEN), true);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.controller_not_found").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (tag.m_128441_("ControllerPos")) {
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.select_conference_room_first").m_130940_(ChatFormatting.YELLOW), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.select_controller_first").m_130940_(ChatFormatting.YELLOW), true);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult handleKeycardDoorLink(Level level, Player player, ItemStack stack, CompoundTag tag, KeycardDoorBlockEntity doorEntity, BlockPos lowerPos) {
        if (tag.m_128441_("RoomId") && tag.m_128441_("ControllerPos")) {
            String roomId = tag.m_128461_("RoomId");
            boolean isConferenceRoom = tag.m_128471_("IsConferenceRoom");
            BlockPos controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPos"));
            if (isConferenceRoom) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.keycard_door_wrong_type").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            BlockEntity controllerBe = level.m_7702_(controllerPos);
            if (controllerBe instanceof HotelControllerBlockEntity) {
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBe;
                if (!controller.isOwner(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.not_owner").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                if (!controller.isDoorInRange(lowerPos)) {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.door_out_of_range").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                doorEntity.linkToRoom(roomId, controllerPos);
                controller.linkDoor(lowerPos);
                RoomData room = controller.getRoom(roomId);
                if (room != null) {
                    room.addLinkedDoor(lowerPos);
                }
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.linker.door_linked", (Object[])new Object[]{tag.m_128461_("RoomName")}).m_130940_(ChatFormatting.GREEN), true);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.controller_not_found").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (tag.m_128441_("ControllerPos")) {
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.select_room_first").m_130940_(ChatFormatting.YELLOW), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.select_controller_first").m_130940_(ChatFormatting.YELLOW), true);
        }
        return InteractionResult.FAIL;
    }

    public static void setSelectedRoom(ItemStack stack, String roomId, String roomName, boolean isConferenceRoom) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("RoomId", roomId);
        tag.m_128359_("RoomName", roomName);
        tag.m_128379_("IsConferenceRoom", isConferenceRoom);
    }

    public static void clearSelection(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("ControllerPos");
        tag.m_128473_("HotelName");
        tag.m_128473_("RoomId");
        tag.m_128473_("RoomName");
        tag.m_128473_("IsConferenceRoom");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        tooltip.add((Component)Component.m_237115_((String)"lchotels.linker.tooltip1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"lchotels.linker.tooltip2").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"lchotels.linker.tooltip3").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"lchotels.linker.tooltip4").m_130940_(ChatFormatting.GRAY));
        if (tag != null) {
            if (tag.m_128441_("HotelName")) {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237113_((String)"Selected Hotel: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)tag.m_128461_("HotelName")).m_130940_(ChatFormatting.WHITE)));
            }
            if (tag.m_128441_("RoomName")) {
                ChatFormatting color = tag.m_128471_("IsConferenceRoom") ? ChatFormatting.BLUE : ChatFormatting.GOLD;
                tooltip.add((Component)Component.m_237113_((String)"Selected Room: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)tag.m_128461_("RoomName")).m_130940_(color)));
            }
        }
    }
}

