/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.menu;

import com.lchotels.blockentity.FrontDeskBlockEntity;
import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import com.lchotels.init.ModBlocks;
import com.lchotels.init.ModMenuTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FrontDeskMenu
extends AbstractContainerMenu {
    private final FrontDeskBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private final Player player;

    public FrontDeskMenu(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, FrontDeskMenu.getBlockEntity(playerInventory, extraData));
    }

    public FrontDeskMenu(int windowId, Inventory playerInventory, FrontDeskBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.FRONT_DESK.get(), windowId);
        this.blockEntity = blockEntity;
        this.player = playerInventory.f_35978_;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 198));
        }
    }

    private static FrontDeskBlockEntity getBlockEntity(Inventory inventory, FriendlyByteBuf data) {
        BlockPos pos = data.m_130135_();
        BlockEntity be = inventory.f_35978_.m_9236_().m_7702_(pos);
        if (be instanceof FrontDeskBlockEntity) {
            FrontDeskBlockEntity frontDesk = (FrontDeskBlockEntity)be;
            return frontDesk;
        }
        throw new IllegalStateException("Block entity is not a FrontDeskBlockEntity at " + String.valueOf(pos));
    }

    public FrontDeskBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Nullable
    public HotelControllerBlockEntity getController() {
        return this.blockEntity.getLinkedController();
    }

    public boolean isLinked() {
        return this.blockEntity.isLinked();
    }

    public String getHotelName() {
        HotelControllerBlockEntity controller = this.getController();
        return controller != null ? controller.getHotelName() : "Not Linked";
    }

    public List<RoomData> getAvailableRooms() {
        HotelControllerBlockEntity controller = this.getController();
        return controller != null ? controller.getAvailableRooms() : Collections.emptyList();
    }

    public List<RoomData> getAvailableRoomsByType(RoomType type) {
        HotelControllerBlockEntity controller = this.getController();
        if (controller == null) {
            return Collections.emptyList();
        }
        return controller.getRoomsByType(type).stream().filter(RoomData::isAvailable).toList();
    }

    public List<RoomData> getPlayerRentals() {
        HotelControllerBlockEntity controller = this.getController();
        if (controller == null) {
            return Collections.emptyList();
        }
        UUID playerId = this.player.m_20148_();
        ArrayList<RoomData> rentals = new ArrayList<RoomData>();
        for (RoomData room : controller.getAllRooms()) {
            if (!room.isRented() || !playerId.equals(room.getCurrentGuest())) continue;
            rentals.add(room);
        }
        return rentals;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            result = stackInSlot.m_41777_();
            if (index < 27 ? !this.m_38903_(stackInSlot, 27, 36, false) : !this.m_38903_(stackInSlot, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        return FrontDeskMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)ModBlocks.FRONT_DESK.get()));
    }
}

