/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.menu;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import com.lchotels.init.ModBlocks;
import com.lchotels.init.ModMenuTypes;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HotelControllerMenu
extends AbstractContainerMenu {
    private final HotelControllerBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;

    public HotelControllerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, HotelControllerMenu.getBlockEntity(playerInventory, extraData));
    }

    public HotelControllerMenu(int windowId, Inventory playerInventory, HotelControllerBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.HOTEL_CONTROLLER.get(), windowId);
        this.blockEntity = blockEntity;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 198));
        }
    }

    private static HotelControllerBlockEntity getBlockEntity(Inventory inventory, FriendlyByteBuf data) {
        BlockPos pos = data.m_130135_();
        BlockEntity be = inventory.f_35978_.m_9236_().m_7702_(pos);
        if (be instanceof HotelControllerBlockEntity) {
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            return controller;
        }
        throw new IllegalStateException("Block entity is not a HotelControllerBlockEntity at " + String.valueOf(pos));
    }

    public HotelControllerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean isOwner(Player player) {
        return this.blockEntity.isOwner(player);
    }

    public String getHotelName() {
        return this.blockEntity.getHotelName();
    }

    public UUID getHotelId() {
        return this.blockEntity.getHotelId();
    }

    public Collection<RoomData> getAllRooms() {
        return this.blockEntity.getAllRooms();
    }

    public List<RoomData> getAvailableRooms() {
        return this.blockEntity.getAvailableRooms();
    }

    public List<RoomData> getRoomsByType(RoomType type) {
        return this.blockEntity.getRoomsByType(type);
    }

    public long getStoredMoney() {
        return this.blockEntity.getStoredMoney();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            result = stackInSlot.m_41777_();
            if (index < 27 ? !this.m_38903_(stackInSlot, 27, 36, false) : !this.m_38903_(stackInSlot, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        return HotelControllerMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)ModBlocks.HOTEL_CONTROLLER.get()));
    }
}

