/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network;

import com.lchotels.LCHotels;
import com.lchotels.network.packets.CheckoutPacket;
import com.lchotels.network.packets.CreateOwnerKeycardPacket;
import com.lchotels.network.packets.CreateRoomPacket;
import com.lchotels.network.packets.DeleteRoomPacket;
import com.lchotels.network.packets.ExtendRentalPacket;
import com.lchotels.network.packets.LinkFrontDeskPacket;
import com.lchotels.network.packets.ManageStaffPacket;
import com.lchotels.network.packets.RenameHotelPacket;
import com.lchotels.network.packets.RentRoomPacket;
import com.lchotels.network.packets.SelectRoomPacket;
import com.lchotels.network.packets.SyncHotelDataPacket;
import com.lchotels.network.packets.ToggleAmenityPacket;
import com.lchotels.network.packets.UpdateRoomPricePacket;
import com.lchotels.network.packets.WithdrawMoneyPacket;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class LCHotelsNetwork {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("lchotels", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void register() {
        CHANNEL.registerMessage(packetId++, CreateRoomPacket.class, CreateRoomPacket::encode, CreateRoomPacket::decode, CreateRoomPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, RentRoomPacket.class, RentRoomPacket::encode, RentRoomPacket::decode, RentRoomPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, CheckoutPacket.class, CheckoutPacket::encode, CheckoutPacket::decode, CheckoutPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, ExtendRentalPacket.class, ExtendRentalPacket::encode, ExtendRentalPacket::decode, ExtendRentalPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, UpdateRoomPricePacket.class, UpdateRoomPricePacket::encode, UpdateRoomPricePacket::decode, UpdateRoomPricePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, LinkFrontDeskPacket.class, LinkFrontDeskPacket::encode, LinkFrontDeskPacket::decode, LinkFrontDeskPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, WithdrawMoneyPacket.class, WithdrawMoneyPacket::encode, WithdrawMoneyPacket::decode, WithdrawMoneyPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, SelectRoomPacket.class, SelectRoomPacket::encode, SelectRoomPacket::decode, SelectRoomPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, DeleteRoomPacket.class, DeleteRoomPacket::encode, DeleteRoomPacket::decode, DeleteRoomPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, RenameHotelPacket.class, RenameHotelPacket::encode, RenameHotelPacket::decode, RenameHotelPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, CreateOwnerKeycardPacket.class, CreateOwnerKeycardPacket::encode, CreateOwnerKeycardPacket::decode, CreateOwnerKeycardPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, ManageStaffPacket.class, ManageStaffPacket::encode, ManageStaffPacket::new, ManageStaffPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, ToggleAmenityPacket.class, ToggleAmenityPacket::encode, ToggleAmenityPacket::new, ToggleAmenityPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(packetId++, SyncHotelDataPacket.class, SyncHotelDataPacket::encode, SyncHotelDataPacket::decode, SyncHotelDataPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        LCHotels.LOGGER.info("LC Hotels network packets registered");
    }

    public static void sendToServer(Object msg) {
        CHANNEL.sendToServer(msg);
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static void sendToAllPlayers(Object msg) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), msg);
    }
}

