/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.config.LCHotelsConfig;
import com.lchotels.data.RoomData;
import com.lchotels.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class CheckoutPacket {
    private final BlockPos controllerPos;
    private final String roomId;
    private final boolean earlyCheckout;

    public CheckoutPacket(BlockPos controllerPos, String roomId, boolean earlyCheckout) {
        this.controllerPos = controllerPos;
        this.roomId = roomId;
        this.earlyCheckout = earlyCheckout;
    }

    public static void encode(CheckoutPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.roomId);
        buf.writeBoolean(msg.earlyCheckout);
    }

    public static CheckoutPacket decode(FriendlyByteBuf buf) {
        return new CheckoutPacket(buf.m_130135_(), buf.m_130277_(), buf.readBoolean());
    }

    public static void handle(CheckoutPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int remainingDays;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.invalid_controller").m_130940_(ChatFormatting.RED), true);
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            RoomData room = controller.getRoom(msg.roomId);
            if (room == null) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.room_not_found").m_130940_(ChatFormatting.RED), true);
                return;
            }
            if (!room.isRented()) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_rented").m_130940_(ChatFormatting.RED), true);
                return;
            }
            boolean isGuest = player.m_20148_().equals(room.getCurrentGuest());
            boolean isOwner = controller.isOwner((Player)player);
            if (!isGuest && !isOwner) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_authorized").m_130940_(ChatFormatting.RED), true);
                return;
            }
            String roomName = room.getRoomName();
            long refundAmount = 0L;
            if (msg.earlyCheckout && isGuest && ((Boolean)LCHotelsConfig.ALLOW_EARLY_CHECKOUT_REFUND.get()).booleanValue() && (remainingDays = room.getRemainingDays(player.m_9236_())) > 0) {
                double refundPercent = (Double)LCHotelsConfig.EARLY_CHECKOUT_REFUND_PERCENT.get();
                refundAmount = (long)((double)(room.getPricePerDay() * (long)remainingDays) * refundPercent);
            }
            controller.processCheckout(msg.roomId, msg.earlyCheckout);
            controller.m_6596_();
            player.m_9236_().m_7260_(msg.controllerPos, controller.m_58900_(), controller.m_58900_(), 3);
            if (refundAmount > 0L && isGuest) {
                MoneyValue refund = MoneyUtil.fromLong(refundAmount);
                MoneyUtil.giveToPlayer((Player)player, refund);
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.checkout.success_with_refund", (Object[])new Object[]{roomName, MoneyUtil.formatMoney(refundAmount)}).m_130940_(ChatFormatting.GREEN), false);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.checkout.success", (Object[])new Object[]{roomName}).m_130940_(ChatFormatting.GREEN), false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

