/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.item.OwnerKeycardItem;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class CreateOwnerKeycardPacket {
    private final BlockPos controllerPos;

    public CreateOwnerKeycardPacket(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    public static void encode(CreateOwnerKeycardPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
    }

    public static CreateOwnerKeycardPacket decode(FriendlyByteBuf buf) {
        return new CreateOwnerKeycardPacket(buf.m_130135_());
    }

    public static void handle(CreateOwnerKeycardPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.isOwner((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner").m_130940_(ChatFormatting.RED), true);
                return;
            }
            ItemStack ownerKeycard = OwnerKeycardItem.createOwnerKeycard(controller.getHotelName(), controller.getHotelId(), controller.getOwnerId(), controller.getOwnerName(), msg.controllerPos);
            if (!player.m_150109_().m_36054_(ownerKeycard)) {
                player.m_36176_(ownerKeycard, false);
            }
            player.m_5661_((Component)Component.m_237115_((String)"lchotels.owner_keycard.created").m_130940_(ChatFormatting.GREEN), true);
        });
        ctx.get().setPacketHandled(true);
    }
}

