/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class CreateRoomPacket {
    private final BlockPos controllerPos;
    private final String roomNumber;
    private final RoomType roomType;
    private final long pricePerDay;

    public CreateRoomPacket(BlockPos controllerPos, String roomNumber, RoomType roomType, long pricePerDay) {
        this.controllerPos = controllerPos;
        this.roomNumber = roomNumber;
        this.roomType = roomType;
        this.pricePerDay = pricePerDay;
    }

    public static void encode(CreateRoomPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.roomNumber);
        buf.m_130068_((Enum)msg.roomType);
        buf.writeLong(msg.pricePerDay);
    }

    public static CreateRoomPacket decode(FriendlyByteBuf buf) {
        return new CreateRoomPacket(buf.m_130135_(), buf.m_130277_(), (RoomType)buf.m_130066_(RoomType.class), buf.readLong());
    }

    public static void handle(CreateRoomPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (be instanceof HotelControllerBlockEntity) {
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
                if (controller.isOwner((Player)player)) {
                    RoomData room = controller.createRoom(msg.roomNumber, msg.roomType, msg.pricePerDay);
                    if (room != null) {
                        controller.m_6596_();
                        player.m_9236_().m_7260_(msg.controllerPos, controller.m_58900_(), controller.m_58900_(), 3);
                        player.m_5661_((Component)Component.m_237110_((String)"lchotels.room.created", (Object[])new Object[]{msg.roomNumber}).m_130940_(ChatFormatting.GREEN), false);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"lchotels.room.create_failed").m_130940_(ChatFormatting.RED), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner").m_130940_(ChatFormatting.RED), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

