/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.RoomData;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class DeleteRoomPacket {
    private final BlockPos controllerPos;
    private final String roomId;

    public DeleteRoomPacket(BlockPos controllerPos, String roomId) {
        this.controllerPos = controllerPos;
        this.roomId = roomId;
    }

    public static void encode(DeleteRoomPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.roomId);
    }

    public static DeleteRoomPacket decode(FriendlyByteBuf buf) {
        return new DeleteRoomPacket(buf.m_130135_(), buf.m_130277_());
    }

    public static void handle(DeleteRoomPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (be instanceof HotelControllerBlockEntity) {
                HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
                if (controller.isOwner((Player)player)) {
                    RoomData room = controller.getRoom(msg.roomId);
                    if (room != null) {
                        if (room.isRented()) {
                            player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.room_occupied").m_130940_(ChatFormatting.RED), true);
                        } else {
                            String roomName = room.getRoomName();
                            controller.removeRoom(msg.roomId);
                            controller.m_6596_();
                            player.m_9236_().m_7260_(msg.controllerPos, controller.m_58900_(), controller.m_58900_(), 3);
                            player.m_5661_((Component)Component.m_237110_((String)"lchotels.room.deleted", (Object[])new Object[]{roomName}).m_130940_(ChatFormatting.GREEN), false);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.room_not_found").m_130940_(ChatFormatting.RED), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner").m_130940_(ChatFormatting.RED), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

