/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.config.LCHotelsConfig;
import com.lchotels.data.RoomData;
import com.lchotels.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ExtendRentalPacket {
    private final BlockPos controllerPos;
    private final String roomId;
    private final int additionalDays;

    public ExtendRentalPacket(BlockPos controllerPos, String roomId, int additionalDays) {
        this.controllerPos = controllerPos;
        this.roomId = roomId;
        this.additionalDays = additionalDays;
    }

    public static void encode(ExtendRentalPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.roomId);
        buf.writeInt(msg.additionalDays);
    }

    public static ExtendRentalPacket decode(FriendlyByteBuf buf) {
        return new ExtendRentalPacket(buf.m_130135_(), buf.m_130277_(), buf.readInt());
    }

    public static void handle(ExtendRentalPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.invalid_controller").m_130940_(ChatFormatting.RED), true);
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            RoomData room = controller.getRoom(msg.roomId);
            if (room == null) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.room_not_found").m_130940_(ChatFormatting.RED), true);
                return;
            }
            if (!room.isRented() || !player.m_20148_().equals(room.getCurrentGuest())) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_authorized").m_130940_(ChatFormatting.RED), true);
                return;
            }
            int currentDays = room.getDaysRented();
            int maxDays = (Integer)LCHotelsConfig.MAX_RENTAL_DAYS.get();
            int remainingDays = room.getRemainingDays(player.m_9236_());
            if (remainingDays + msg.additionalDays > maxDays) {
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.error.max_days_exceeded", (Object[])new Object[]{maxDays}).m_130940_(ChatFormatting.RED), true);
                return;
            }
            long totalCost = room.getPricePerDay() * (long)msg.additionalDays;
            MoneyValue cost = MoneyUtil.fromLong(totalCost);
            if (!MoneyUtil.hasAmount((Player)player, cost)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.insufficient_funds").m_130940_(ChatFormatting.RED), true);
                return;
            }
            if (!MoneyUtil.takeFromPlayer((Player)player, cost)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.payment_failed").m_130940_(ChatFormatting.RED), true);
                return;
            }
            room.extendRental(msg.additionalDays);
            controller.addMoney(totalCost);
            controller.m_6596_();
            player.m_9236_().m_7260_(msg.controllerPos, controller.m_58900_(), controller.m_58900_(), 3);
            player.m_5661_((Component)Component.m_237110_((String)"lchotels.rental.extended", (Object[])new Object[]{msg.additionalDays, room.getRoomName()}).m_130940_(ChatFormatting.GREEN), true);
        });
        ctx.get().setPacketHandled(true);
    }
}

