/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.FrontDeskBlockEntity;
import com.lchotels.blockentity.HotelControllerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class LinkFrontDeskPacket {
    private final BlockPos frontDeskPos;
    private final BlockPos controllerPos;

    public LinkFrontDeskPacket(BlockPos frontDeskPos, BlockPos controllerPos) {
        this.frontDeskPos = frontDeskPos;
        this.controllerPos = controllerPos;
    }

    public static void encode(LinkFrontDeskPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.frontDeskPos);
        buf.m_130064_(msg.controllerPos);
    }

    public static LinkFrontDeskPacket decode(FriendlyByteBuf buf) {
        return new LinkFrontDeskPacket(buf.m_130135_(), buf.m_130135_());
    }

    public static void handle(LinkFrontDeskPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity frontDeskBe = player.m_9236_().m_7702_(msg.frontDeskPos);
            BlockEntity controllerBe = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(frontDeskBe instanceof FrontDeskBlockEntity)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.invalid_front_desk"), true);
                return;
            }
            FrontDeskBlockEntity frontDesk = (FrontDeskBlockEntity)frontDeskBe;
            if (!(controllerBe instanceof HotelControllerBlockEntity)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.invalid_controller"), true);
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)controllerBe;
            if (!controller.isOwner((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner"), true);
                return;
            }
            frontDesk.linkToController(msg.controllerPos);
            player.m_5661_((Component)Component.m_237110_((String)"lchotels.front_desk.linked", (Object[])new Object[]{controller.getHotelName()}), true);
        });
        ctx.get().setPacketHandled(true);
    }
}

