/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ManageStaffPacket {
    private final BlockPos controllerPos;
    private final Action action;
    private final String playerName;
    private final UUID playerId;

    public ManageStaffPacket(BlockPos controllerPos, Action action, String playerName) {
        this.controllerPos = controllerPos;
        this.action = action;
        this.playerName = playerName;
        this.playerId = null;
    }

    public ManageStaffPacket(BlockPos controllerPos, Action action, UUID playerId) {
        this.controllerPos = controllerPos;
        this.action = action;
        this.playerName = "";
        this.playerId = playerId;
    }

    public ManageStaffPacket(FriendlyByteBuf buf) {
        this.controllerPos = buf.m_130135_();
        this.action = (Action)buf.m_130066_(Action.class);
        this.playerName = buf.m_130277_();
        this.playerId = buf.readBoolean() ? buf.m_130259_() : null;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.controllerPos);
        buf.m_130068_((Enum)this.action);
        buf.m_130070_(this.playerName);
        buf.writeBoolean(this.playerId != null);
        if (this.playerId != null) {
            buf.m_130077_(this.playerId);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            BlockEntity be = level.m_7702_(this.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.canManageStaff((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner").m_130940_(ChatFormatting.RED), true);
                return;
            }
            switch (this.action) {
                case ADD_STAFF: {
                    ServerPlayer targetPlayer = level.m_7654_().m_6846_().m_11255_(this.playerName);
                    if (targetPlayer != null) {
                        if (controller.getStaffMembers().containsKey(targetPlayer.m_20148_())) {
                            player.m_5661_((Component)Component.m_237110_((String)"lchotels.staff.already_exists", (Object[])new Object[]{this.playerName}).m_130940_(ChatFormatting.YELLOW), true);
                            break;
                        }
                        controller.addStaffMember(targetPlayer.m_20148_(), targetPlayer.m_7755_().getString());
                        player.m_5661_((Component)Component.m_237110_((String)"lchotels.staff.added", (Object[])new Object[]{this.playerName}).m_130940_(ChatFormatting.GREEN), true);
                        break;
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.staff.player_not_found").m_130940_(ChatFormatting.RED), true);
                    break;
                }
                case REMOVE_STAFF: {
                    if (this.playerId == null) break;
                    String removedName = controller.getStaffMembers().get(this.playerId);
                    controller.removeStaffMember(this.playerId);
                    player.m_5661_((Component)Component.m_237110_((String)"lchotels.staff.removed", (Object[])new Object[]{removedName != null ? removedName : "Staff"}).m_130940_(ChatFormatting.GREEN), true);
                    break;
                }
                case ADD_COOWNER: {
                    ServerPlayer targetPlayer = level.m_7654_().m_6846_().m_11255_(this.playerName);
                    if (targetPlayer != null) {
                        if (controller.getCoOwners().containsKey(targetPlayer.m_20148_())) {
                            player.m_5661_((Component)Component.m_237110_((String)"lchotels.coowner.already_exists", (Object[])new Object[]{this.playerName}).m_130940_(ChatFormatting.YELLOW), true);
                            break;
                        }
                        controller.addCoOwner(targetPlayer.m_20148_(), targetPlayer.m_7755_().getString());
                        player.m_5661_((Component)Component.m_237110_((String)"lchotels.coowner.added", (Object[])new Object[]{this.playerName}).m_130940_(ChatFormatting.GREEN), true);
                        break;
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"lchotels.staff.player_not_found").m_130940_(ChatFormatting.RED), true);
                    break;
                }
                case REMOVE_COOWNER: {
                    if (this.playerId == null) break;
                    String removedName = controller.getCoOwners().get(this.playerId);
                    controller.removeCoOwner(this.playerId);
                    player.m_5661_((Component)Component.m_237110_((String)"lchotels.coowner.removed", (Object[])new Object[]{removedName != null ? removedName : "Co-Owner"}).m_130940_(ChatFormatting.GREEN), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Action {
        ADD_STAFF,
        REMOVE_STAFF,
        ADD_COOWNER,
        REMOVE_COOWNER;

    }
}

