/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.config.LCHotelsConfig;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class RenameHotelPacket {
    private final BlockPos controllerPos;
    private final String newName;

    public RenameHotelPacket(BlockPos controllerPos, String newName) {
        this.controllerPos = controllerPos;
        this.newName = newName;
    }

    public static void encode(RenameHotelPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.newName);
    }

    public static RenameHotelPacket decode(FriendlyByteBuf buf) {
        return new RenameHotelPacket(buf.m_130135_(), buf.m_130277_());
    }

    public static void handle(RenameHotelPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.isOwner((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner").m_130940_(ChatFormatting.RED), true);
                return;
            }
            String name = msg.newName.trim();
            if (name.isEmpty()) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.invalid_name").m_130940_(ChatFormatting.RED), true);
                return;
            }
            int maxLength = (Integer)LCHotelsConfig.MAX_HOTEL_NAME_LENGTH.get();
            if (name.length() > maxLength) {
                name = name.substring(0, maxLength);
            }
            controller.setHotelName(name);
            controller.m_6596_();
            player.m_9236_().m_7260_(msg.controllerPos, controller.m_58900_(), controller.m_58900_(), 3);
            player.m_5661_((Component)Component.m_237110_((String)"lchotels.hotel.renamed", (Object[])new Object[]{name}).m_130940_(ChatFormatting.GREEN), true);
        });
        ctx.get().setPacketHandled(true);
    }
}

