/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.RoomData;
import com.lchotels.item.KeycardItem;
import com.lchotels.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class RentRoomPacket {
    private final BlockPos controllerPos;
    private final String roomId;
    private final int days;

    public RentRoomPacket(BlockPos controllerPos, String roomId, int days) {
        this.controllerPos = controllerPos;
        this.roomId = roomId;
        this.days = days;
    }

    public static void encode(RentRoomPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.roomId);
        buf.writeInt(msg.days);
    }

    public static RentRoomPacket decode(FriendlyByteBuf buf) {
        return new RentRoomPacket(buf.m_130135_(), buf.m_130277_(), buf.readInt());
    }

    public static void handle(RentRoomPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            RoomData room = controller.getRoom(msg.roomId);
            if (room == null || !room.isAvailable()) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.room_unavailable"), true);
                return;
            }
            long totalCost = room.getPricePerDay() * (long)msg.days;
            MoneyValue cost = MoneyUtil.fromLong(totalCost);
            if (!MoneyUtil.hasAmount((Player)player, cost)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.insufficient_funds"), true);
                return;
            }
            if (!MoneyUtil.takeFromPlayer((Player)player, cost)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.payment_failed"), true);
                return;
            }
            if (controller.processRental(msg.roomId, player.m_20148_(), player.m_7755_().getString(), msg.days, totalCost)) {
                long expirationTime = player.m_9236_().m_46467_() + (long)msg.days * 24000L;
                ItemStack keycard = KeycardItem.createKeycard(controller.getHotelName(), msg.roomId, room.getRoomName(), player.m_20148_(), player.m_7755_().getString(), expirationTime, msg.controllerPos);
                if (!player.m_150109_().m_36054_(keycard)) {
                    player.m_36176_(keycard, false);
                }
                controller.m_6596_();
                player.m_9236_().m_7260_(msg.controllerPos, controller.m_58900_(), controller.m_58900_(), 3);
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.rental.success", (Object[])new Object[]{room.getRoomName(), msg.days}), true);
            } else {
                MoneyUtil.giveToPlayer((Player)player, cost);
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.rental_failed"), true);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

