/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.RoomData;
import com.lchotels.init.ModItems;
import com.lchotels.item.RoomLinkerItem;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SelectRoomPacket {
    private final BlockPos controllerPos;
    private final String roomId;
    private final String roomName;

    public SelectRoomPacket(BlockPos controllerPos, String roomId, String roomName) {
        this.controllerPos = controllerPos;
        this.roomId = roomId;
        this.roomName = roomName;
    }

    public static void encode(SelectRoomPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.roomId);
        buf.m_130070_(msg.roomName);
    }

    public static SelectRoomPacket decode(FriendlyByteBuf buf) {
        return new SelectRoomPacket(buf.m_130135_(), buf.m_130277_(), buf.m_130277_());
    }

    public static void handle(SelectRoomPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.isOwner((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner").m_130940_(ChatFormatting.RED), true);
                return;
            }
            RoomData room = controller.getRoom(msg.roomId);
            if (room == null) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.room_not_found").m_130940_(ChatFormatting.RED), true);
                return;
            }
            boolean isConferenceRoom = room.getRoomType().isConferenceRoom();
            ItemStack linker = null;
            int linkerSlot = -1;
            if (player.m_21205_().m_150930_((Item)ModItems.ROOM_LINKER.get())) {
                linker = player.m_21205_();
            } else if (player.m_21206_().m_150930_((Item)ModItems.ROOM_LINKER.get())) {
                linker = player.m_21206_();
            } else {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    if (!stack.m_150930_((Item)ModItems.ROOM_LINKER.get())) continue;
                    linker = stack;
                    linkerSlot = i;
                    break;
                }
            }
            if (linker != null) {
                RoomLinkerItem.setSelectedRoom(linker, msg.roomId, room.getRoomName(), isConferenceRoom);
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.linker.room_selected", (Object[])new Object[]{room.getRoomName()}).m_130940_(ChatFormatting.GREEN), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.linker.hold_linker").m_130940_(ChatFormatting.YELLOW), true);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

