/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.data.RoomData;
import com.lchotels.data.RoomType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncHotelDataPacket {
    private final BlockPos controllerPos;
    private final String hotelName;
    private final UUID hotelId;
    private final List<RoomSyncData> rooms;
    private final long storedMoney;

    public SyncHotelDataPacket(BlockPos controllerPos, String hotelName, UUID hotelId, List<RoomSyncData> rooms, long storedMoney) {
        this.controllerPos = controllerPos;
        this.hotelName = hotelName;
        this.hotelId = hotelId;
        this.rooms = rooms;
        this.storedMoney = storedMoney;
    }

    public static void encode(SyncHotelDataPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.hotelName);
        buf.m_130077_(msg.hotelId);
        buf.writeLong(msg.storedMoney);
        buf.writeInt(msg.rooms.size());
        for (RoomSyncData room : msg.rooms) {
            buf.m_130070_(room.roomId);
            buf.m_130070_(room.roomName);
            buf.m_130068_((Enum)room.roomType);
            buf.writeLong(room.pricePerDay);
            buf.writeBoolean(room.isAvailable);
            buf.m_130070_(room.guestName != null ? room.guestName : "");
            buf.writeInt(room.remainingDays);
        }
    }

    public static SyncHotelDataPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        String name = buf.m_130277_();
        UUID id = buf.m_130259_();
        long money = buf.readLong();
        int roomCount = buf.readInt();
        ArrayList<RoomSyncData> rooms = new ArrayList<RoomSyncData>();
        for (int i = 0; i < roomCount; ++i) {
            rooms.add(new RoomSyncData(buf.m_130277_(), buf.m_130277_(), (RoomType)buf.m_130066_(RoomType.class), buf.readLong(), buf.readBoolean(), buf.m_130277_(), buf.readInt()));
        }
        return new SyncHotelDataPacket(pos, name, id, rooms, money);
    }

    public static void handle(SyncHotelDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {});
        ctx.get().setPacketHandled(true);
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public String getHotelName() {
        return this.hotelName;
    }

    public UUID getHotelId() {
        return this.hotelId;
    }

    public List<RoomSyncData> getRooms() {
        return this.rooms;
    }

    public long getStoredMoney() {
        return this.storedMoney;
    }

    public static class RoomSyncData {
        public String roomId;
        public String roomName;
        public RoomType roomType;
        public long pricePerDay;
        public boolean isAvailable;
        public String guestName;
        public int remainingDays;

        public RoomSyncData(RoomData room, int remainingDays) {
            this.roomId = room.getRoomId();
            this.roomName = room.getRoomName();
            this.roomType = room.getRoomType();
            this.pricePerDay = room.getPricePerDay();
            this.isAvailable = room.isAvailable();
            this.guestName = room.getCurrentGuestName();
            this.remainingDays = remainingDays;
        }

        public RoomSyncData(String roomId, String roomName, RoomType roomType, long pricePerDay, boolean isAvailable, String guestName, int remainingDays) {
            this.roomId = roomId;
            this.roomName = roomName;
            this.roomType = roomType;
            this.pricePerDay = pricePerDay;
            this.isAvailable = isAvailable;
            this.guestName = guestName;
            this.remainingDays = remainingDays;
        }
    }
}

