/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.AmenityType;
import com.lchotels.data.RoomType;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ToggleAmenityPacket {
    private final BlockPos controllerPos;
    private final RoomType roomType;
    private final AmenityType amenityType;

    public ToggleAmenityPacket(BlockPos controllerPos, RoomType roomType, AmenityType amenityType) {
        this.controllerPos = controllerPos;
        this.roomType = roomType;
        this.amenityType = amenityType;
    }

    public ToggleAmenityPacket(FriendlyByteBuf buf) {
        this.controllerPos = buf.m_130135_();
        this.roomType = (RoomType)buf.m_130066_(RoomType.class);
        this.amenityType = (AmenityType)buf.m_130066_(AmenityType.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.controllerPos);
        buf.m_130068_((Enum)this.roomType);
        buf.m_130068_((Enum)this.amenityType);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            BlockEntity be = level.m_7702_(this.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.canConfigureAmenities((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_authorized").m_130940_(ChatFormatting.RED), true);
                return;
            }
            controller.toggleAmenityForRoomType(this.roomType, this.amenityType);
            boolean nowEnabled = controller.roomTypeHasAmenity(this.roomType, this.amenityType);
            player.m_5661_((Component)Component.m_237113_((String)(this.amenityType.getDisplayName() + " access for " + this.roomType.getDisplayName() + ": " + (nowEnabled ? "Enabled" : "Disabled"))).m_130940_(nowEnabled ? ChatFormatting.GREEN : ChatFormatting.RED), true);
        });
        ctx.get().setPacketHandled(true);
    }
}

