/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.data.RoomData;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateRoomPricePacket {
    private final BlockPos controllerPos;
    private final String roomId;
    private final long newPrice;

    public UpdateRoomPricePacket(BlockPos controllerPos, String roomId, long newPrice) {
        this.controllerPos = controllerPos;
        this.roomId = roomId;
        this.newPrice = newPrice;
    }

    public static void encode(UpdateRoomPricePacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.m_130070_(msg.roomId);
        buf.writeLong(msg.newPrice);
    }

    public static UpdateRoomPricePacket decode(FriendlyByteBuf buf) {
        return new UpdateRoomPricePacket(buf.m_130135_(), buf.m_130277_(), buf.readLong());
    }

    public static void handle(UpdateRoomPricePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.isOwner((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner"), true);
                return;
            }
            RoomData room = controller.getRoom(msg.roomId);
            if (room == null) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.room_not_found"), true);
                return;
            }
            room.setPricePerDay(msg.newPrice);
            controller.m_6596_();
            player.m_5661_((Component)Component.m_237110_((String)"lchotels.room.price_updated", (Object[])new Object[]{room.getRoomName()}), true);
        });
        ctx.get().setPacketHandled(true);
    }
}

