/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.network.packets;

import com.lchotels.blockentity.HotelControllerBlockEntity;
import com.lchotels.util.MoneyUtil;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class WithdrawMoneyPacket {
    private final BlockPos controllerPos;
    private final long amount;

    public WithdrawMoneyPacket(BlockPos controllerPos, long amount) {
        this.controllerPos = controllerPos;
        this.amount = amount;
    }

    public static void encode(WithdrawMoneyPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.controllerPos);
        buf.writeLong(msg.amount);
    }

    public static WithdrawMoneyPacket decode(FriendlyByteBuf buf) {
        return new WithdrawMoneyPacket(buf.m_130135_(), buf.readLong());
    }

    public static void handle(WithdrawMoneyPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity be = player.m_9236_().m_7702_(msg.controllerPos);
            if (!(be instanceof HotelControllerBlockEntity)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.invalid_controller").m_130940_(ChatFormatting.RED), true);
                return;
            }
            HotelControllerBlockEntity controller = (HotelControllerBlockEntity)be;
            if (!controller.isOwner((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.not_owner").m_130940_(ChatFormatting.RED), true);
                return;
            }
            long storedMoney = controller.getStoredMoney();
            if (storedMoney <= 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"lchotels.error.no_money").m_130940_(ChatFormatting.RED), true);
                return;
            }
            long toWithdraw = msg.amount <= 0L ? storedMoney : Math.min(msg.amount, storedMoney);
            long withdrawn = controller.withdrawMoney(toWithdraw);
            if (withdrawn > 0L) {
                MoneyUtil.giveToPlayer((Player)player, withdrawn);
                controller.m_6596_();
                player.m_9236_().m_7260_(msg.controllerPos, controller.m_58900_(), controller.m_58900_(), 3);
                player.m_5661_((Component)Component.m_237110_((String)"lchotels.withdraw.success", (Object[])new Object[]{MoneyUtil.formatMoney(withdrawn)}).m_130940_(ChatFormatting.GREEN), false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

