/*
 * Decompiled with CFR 0.152.
 */
package com.lchotels.util;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MoneyUtil {
    private static final long COPPER_VALUE = 1L;
    private static final long IRON_VALUE = 10L;
    private static final long GOLD_VALUE = 100L;
    private static final long EMERALD_VALUE = 1000L;
    private static final long DIAMOND_VALUE = 10000L;
    private static final long NETHERITE_VALUE = 100000L;

    public static long getPlayerBalance(Player player) {
        long total = 0L;
        total += MoneyUtil.getWalletBalance(player);
        return total += MoneyUtil.getInventoryBalance(player);
    }

    private static long getWalletBalance(Player player) {
        try {
            ItemStack wallet;
            IWalletHandler handler = WalletCapability.lazyGetWalletHandler((Entity)player);
            if (handler != null && !(wallet = handler.getWallet()).m_41619_() && wallet.m_41720_() instanceof WalletItem) {
                return MoneyUtil.getWalletContentsValue(wallet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private static long getWalletContentsValue(ItemStack wallet) {
        if (wallet.m_41619_()) {
            return 0L;
        }
        try {
            SimpleContainer contents = WalletItem.getWalletInventory((ItemStack)wallet);
            long total = 0L;
            for (int i = 0; i < contents.m_6643_(); ++i) {
                long value;
                ItemStack stack = contents.m_8020_(i);
                if (stack.m_41619_() || (value = MoneyUtil.getCoinValue(stack.m_41720_())) <= 0L) continue;
                total += value * (long)stack.m_41613_();
            }
            return total;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static long getInventoryBalance(Player player) {
        long total = 0L;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            long value;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() instanceof WalletItem || (value = MoneyUtil.getCoinValue(stack.m_41720_())) <= 0L) continue;
            total += value * (long)stack.m_41613_();
        }
        return total;
    }

    private static long getCoinValue(Item item) {
        if (item == ModItems.COIN_COPPER.get()) {
            return 1L;
        }
        if (item == ModItems.COIN_IRON.get()) {
            return 10L;
        }
        if (item == ModItems.COIN_GOLD.get()) {
            return 100L;
        }
        if (item == ModItems.COIN_EMERALD.get()) {
            return 1000L;
        }
        if (item == ModItems.COIN_DIAMOND.get()) {
            return 10000L;
        }
        if (item == ModItems.COIN_NETHERITE.get()) {
            return 100000L;
        }
        return 0L;
    }

    public static boolean hasAmount(Player player, MoneyValue amount) {
        return MoneyUtil.hasAmount(player, amount.getCoreValue());
    }

    public static boolean hasAmount(Player player, long amount) {
        return MoneyUtil.getPlayerBalance(player) >= amount;
    }

    public static boolean takeFromPlayer(Player player, MoneyValue amount) {
        return MoneyUtil.takeFromPlayer(player, amount.getCoreValue());
    }

    public static boolean takeFromPlayer(Player player, long amount) {
        if (amount <= 0L) {
            return true;
        }
        if (!MoneyUtil.hasAmount(player, amount)) {
            return false;
        }
        long remaining = amount;
        if ((remaining = MoneyUtil.takeFromWallet(player, remaining)) > 0L) {
            remaining = MoneyUtil.takeFromInventory(player, remaining);
        }
        return remaining <= 0L;
    }

    private static long takeFromWallet(Player player, long amount) {
        if (amount <= 0L) {
            return 0L;
        }
        try {
            ItemStack wallet;
            IWalletHandler handler = WalletCapability.lazyGetWalletHandler((Entity)player);
            if (handler != null && !(wallet = handler.getWallet()).m_41619_() && wallet.m_41720_() instanceof WalletItem) {
                SimpleContainer contents = WalletItem.getWalletInventory((ItemStack)wallet);
                long remaining = MoneyUtil.takeFromContainer((Container)contents, amount);
                WalletItem.putWalletInventory((ItemStack)wallet, (Container)contents);
                handler.setWallet(wallet);
                return remaining;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amount;
    }

    private static long takeFromInventory(Player player, long amount) {
        ItemStack stack;
        int i;
        long coinValue;
        Item[] coinOrder;
        if (amount <= 0L) {
            return 0L;
        }
        long remaining = amount;
        for (Item coinItem : coinOrder = new Item[]{(Item)ModItems.COIN_NETHERITE.get(), (Item)ModItems.COIN_DIAMOND.get(), (Item)ModItems.COIN_EMERALD.get(), (Item)ModItems.COIN_GOLD.get(), (Item)ModItems.COIN_IRON.get(), (Item)ModItems.COIN_COPPER.get()}) {
            if (remaining <= 0L) break;
            coinValue = MoneyUtil.getCoinValue(coinItem);
            if (coinValue > remaining) continue;
            for (i = 0; i < player.m_150109_().m_6643_() && remaining > 0L; ++i) {
                int coinsNeeded;
                stack = player.m_150109_().m_8020_(i);
                if (stack.m_41720_() != coinItem || (coinsNeeded = (int)Math.min((long)stack.m_41613_(), remaining / coinValue)) <= 0) continue;
                remaining -= (long)coinsNeeded * coinValue;
                stack.m_41774_(coinsNeeded);
                if (!stack.m_41619_()) continue;
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
        }
        if (remaining > 0L) {
            for (Item coinItem : coinOrder) {
                coinValue = MoneyUtil.getCoinValue(coinItem);
                if (coinValue >= remaining) {
                    for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        long change;
                        stack = player.m_150109_().m_8020_(i);
                        if (stack.m_41720_() != coinItem || stack.m_41613_() <= 0) continue;
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                        }
                        if ((change = coinValue - remaining) > 0L) {
                            MoneyUtil.giveCoinsToInventory(player, change);
                        }
                        remaining = 0L;
                        break;
                    }
                }
                if (remaining <= 0L) break;
            }
        }
        return remaining;
    }

    private static long takeFromContainer(Container container, long amount) {
        Item[] coinOrder;
        long remaining = amount;
        for (Item coinItem : coinOrder = new Item[]{(Item)ModItems.COIN_NETHERITE.get(), (Item)ModItems.COIN_DIAMOND.get(), (Item)ModItems.COIN_EMERALD.get(), (Item)ModItems.COIN_GOLD.get(), (Item)ModItems.COIN_IRON.get(), (Item)ModItems.COIN_COPPER.get()}) {
            if (remaining <= 0L) break;
            long coinValue = MoneyUtil.getCoinValue(coinItem);
            if (coinValue > remaining) continue;
            for (int i = 0; i < container.m_6643_() && remaining > 0L; ++i) {
                int coinsNeeded;
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41720_() != coinItem || (coinsNeeded = (int)Math.min((long)stack.m_41613_(), remaining / coinValue)) <= 0) continue;
                remaining -= (long)coinsNeeded * coinValue;
                stack.m_41774_(coinsNeeded);
                if (!stack.m_41619_()) continue;
                container.m_6836_(i, ItemStack.f_41583_);
            }
        }
        return remaining;
    }

    public static void giveToPlayer(Player player, MoneyValue amount) {
        MoneyUtil.giveToPlayer(player, amount.getCoreValue());
    }

    public static void giveToPlayer(Player player, long amount) {
        if (amount <= 0L) {
            return;
        }
        long remaining = MoneyUtil.giveToWallet(player, amount);
        if (remaining > 0L) {
            MoneyUtil.giveCoinsToInventory(player, remaining);
        }
    }

    private static long giveToWallet(Player player, long amount) {
        if (amount <= 0L) {
            return 0L;
        }
        try {
            ItemStack wallet;
            IWalletHandler handler = WalletCapability.lazyGetWalletHandler((Entity)player);
            if (handler != null && !(wallet = handler.getWallet()).m_41619_() && wallet.m_41720_() instanceof WalletItem) {
                SimpleContainer contents = WalletItem.getWalletInventory((ItemStack)wallet);
                long remaining = MoneyUtil.giveToContainer((Container)contents, amount);
                WalletItem.putWalletInventory((ItemStack)wallet, (Container)contents);
                handler.setWallet(wallet);
                return remaining;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amount;
    }

    private static long giveToContainer(Container container, long amount) {
        Object[][] coinData;
        long remaining = amount;
        for (Object[] data : coinData = new Object[][]{{ModItems.COIN_NETHERITE.get(), 100000L}, {ModItems.COIN_DIAMOND.get(), 10000L}, {ModItems.COIN_EMERALD.get(), 1000L}, {ModItems.COIN_GOLD.get(), 100L}, {ModItems.COIN_IRON.get(), 10L}, {ModItems.COIN_COPPER.get(), 1L}}) {
            int toAdd;
            ItemStack stack;
            int i;
            Item coinItem = (Item)data[0];
            long coinValue = (Long)data[1];
            int coinCount = (int)(remaining / coinValue);
            if (coinCount <= 0) continue;
            for (i = 0; i < container.m_6643_() && coinCount > 0; ++i) {
                stack = container.m_8020_(i);
                if (stack.m_41720_() != coinItem || stack.m_41613_() >= stack.m_41741_()) continue;
                toAdd = Math.min(coinCount, stack.m_41741_() - stack.m_41613_());
                stack.m_41769_(toAdd);
                coinCount -= toAdd;
                remaining -= (long)toAdd * coinValue;
            }
            for (i = 0; i < container.m_6643_() && coinCount > 0; ++i) {
                stack = container.m_8020_(i);
                if (!stack.m_41619_()) continue;
                toAdd = Math.min(coinCount, 64);
                container.m_6836_(i, new ItemStack((ItemLike)coinItem, toAdd));
                coinCount -= toAdd;
                remaining -= (long)toAdd * coinValue;
            }
        }
        return remaining;
    }

    private static void giveCoinsToInventory(Player player, long amount) {
        Object[][] coinData;
        long remaining = amount;
        for (Object[] data : coinData = new Object[][]{{ModItems.COIN_NETHERITE.get(), 100000L}, {ModItems.COIN_DIAMOND.get(), 10000L}, {ModItems.COIN_EMERALD.get(), 1000L}, {ModItems.COIN_GOLD.get(), 100L}, {ModItems.COIN_IRON.get(), 10L}, {ModItems.COIN_COPPER.get(), 1L}}) {
            Item coinItem = (Item)data[0];
            long coinValue = (Long)data[1];
            int coinCount = (int)(remaining / coinValue);
            if (coinCount <= 0) continue;
            remaining -= (long)coinCount * coinValue;
            while (coinCount > 0) {
                int stackSize = Math.min(coinCount, 64);
                ItemStack coinStack = new ItemStack((ItemLike)coinItem, stackSize);
                if (!player.m_150109_().m_36054_(coinStack)) {
                    player.m_36176_(coinStack, false);
                }
                coinCount -= stackSize;
            }
        }
    }

    public static MoneyValue fromLong(long value) {
        return CoinValue.fromNumber((String)"main", (long)value);
    }

    public static String formatMoney(MoneyValue value) {
        if (value == null || value.isEmpty()) {
            return "0 coins";
        }
        String lcText = value.getText().getString();
        if (lcText != null && !lcText.isEmpty()) {
            return lcText;
        }
        return MoneyUtil.formatMoney(value.getCoreValue());
    }

    public static String formatMoney(long value) {
        long count;
        String lcText;
        if (value <= 0L) {
            return "0 coins";
        }
        MoneyValue mv = MoneyUtil.fromLong(value);
        if (mv != null && !mv.isEmpty() && (lcText = mv.getText().getString()) != null && !lcText.isEmpty()) {
            return lcText;
        }
        StringBuilder sb = new StringBuilder();
        long remaining = value;
        if (remaining >= 100000L) {
            count = remaining / 100000L;
            remaining %= 100000L;
            sb.append(count).append("n");
        }
        if (remaining >= 10000L) {
            count = remaining / 10000L;
            remaining %= 10000L;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(count).append("d");
        }
        if (remaining >= 1000L) {
            count = remaining / 1000L;
            remaining %= 1000L;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(count).append("e");
        }
        if (remaining >= 100L) {
            count = remaining / 100L;
            remaining %= 100L;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(count).append("g");
        }
        if (remaining >= 10L) {
            count = remaining / 10L;
            remaining %= 10L;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(count).append("i");
        }
        if (remaining >= 1L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(remaining).append("c");
        }
        return sb.length() > 0 ? sb.toString() : "0 coins";
    }
}

