/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ImageIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("texture"), ImageIcon::loadIcon, ImageIcon::parseIcon);
    private final NormalSprite sprite;

    private ImageIcon(NormalSprite sprite) {
        super(TYPE);
        this.sprite = sprite;
    }

    public static IconData ofImage(ResourceLocation image, int u, int v) {
        return ImageIcon.ofImage(new SpriteSource(image, u, v, 16, 16));
    }

    public static IconData ofImage(SpriteSource sprite) {
        return new ImageIcon(new NormalSprite(sprite));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EasyGuiGraphics gui, int x, int y) {
        this.sprite.render(gui, x, y);
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.m_128359_("Image", this.sprite.image.texture().toString());
        tag.m_128405_("u", this.sprite.image.u());
        tag.m_128405_("v", this.sprite.image.v());
        tag.m_128405_("w", this.sprite.image.width());
        tag.m_128405_("h", this.sprite.image.height());
        tag.m_128405_("tw", this.sprite.image.textureWidth());
        tag.m_128405_("th", this.sprite.image.textureHeight());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("Image", this.sprite.image.texture().toString());
        json.addProperty("u", (Number)this.sprite.image.u());
        json.addProperty("v", (Number)this.sprite.image.v());
        json.addProperty("w", (Number)this.sprite.image.width());
        json.addProperty("h", (Number)this.sprite.image.height());
        json.addProperty("tw", (Number)this.sprite.image.textureWidth());
        json.addProperty("th", (Number)this.sprite.image.textureHeight());
    }

    private static IconData loadIcon(CompoundTag tag) {
        ResourceLocation image = VersionUtil.parseResource(tag.m_128461_("Image"));
        int u = tag.m_128451_("u");
        int v = tag.m_128451_("v");
        int w = tag.m_128451_("w");
        int h = tag.m_128451_("h");
        int tw = tag.m_128451_("tw");
        int th = tag.m_128451_("th");
        return ImageIcon.ofImage(new SpriteSource(image, u, v, w, h, tw, th));
    }

    private static IconData parseIcon(JsonObject json) {
        ResourceLocation image = VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"Image"));
        int u = GsonHelper.m_13927_((JsonObject)json, (String)"u");
        int v = GsonHelper.m_13927_((JsonObject)json, (String)"v");
        int w = GsonHelper.m_13927_((JsonObject)json, (String)"w");
        int h = GsonHelper.m_13927_((JsonObject)json, (String)"h");
        int tw = GsonHelper.m_13927_((JsonObject)json, (String)"tw");
        int th = GsonHelper.m_13927_((JsonObject)json, (String)"th");
        return ImageIcon.ofImage(new SpriteSource(image, u, v, w, h, tw, th));
    }
}

