/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.world;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.mixin.TemplatePoolAccess;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LCStructures {
    private static final Map<ResourceLocation, Function<RegistryAccess, Holder<StructureProcessorList>>> structureProcessors;
    public static final ResourceKey<StructureProcessorList> PROCESSOR_DESERT_BANKER_ARCHAEOLOGY;
    public static final ResourceKey<StructureProcessorList> PROCESSOR_PLAINS_SHOP_ARCHAEOLOGY;
    public static final ResourceKey<StructureProcessorList> PROCESSOR_TAIGA_SHOP_ARCHAEOLOGY;
    public static final ResourceKey<StructureProcessorList> PROCESSOR_DESERT_SHOP_ARCHAEOLOGY;
    public static final ResourceKey<StructureProcessorList> PROCESSOR_IDAS_TAIGA_LARGE_BANK;
    public static final ResourceKey<StructureProcessorList> PROCESSOR_ANCIENT_RUINS;
    public static final ResourceKey<StructureSet> STRUCTURE_NETHER_RUINS;

    private static List<String> villageBiomes() {
        return ImmutableList.of((Object)"plains", (Object)"snowy", (Object)"savanna", (Object)"desert", (Object)"taiga");
    }

    private static List<String> houseTypes() {
        return ImmutableList.of((Object)"banker", (Object)"shop");
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        boolean spawnIDAS;
        if (event.getUpdateCause() != TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            return;
        }
        RegistryAccess registryAccess = event.getRegistryAccess();
        boolean bl = spawnIDAS = ModList.get().isLoaded("idas") && (Boolean)LCConfig.COMMON.structureIDAS.get() != false;
        if (((Boolean)LCConfig.COMMON.structureVillageHouses.get()).booleanValue()) {
            for (String biome : LCStructures.villageBiomes()) {
                ResourceLocation housePool = VersionUtil.vanillaResource("village/" + biome + "/houses");
                for (String type : LCStructures.houseTypes()) {
                    LCStructures.addToPool(housePool, VersionUtil.lcResource("village/houses/" + biome + "_" + type), registryAccess, 3);
                }
            }
            if (spawnIDAS) {
                LCStructures.addToPool(VersionUtil.vanillaResource("village/taiga/houses"), VersionUtil.lcResource("village/houses/idas_taiga_large_bank"), registryAccess, 1);
                LCStructures.addToPool(VersionUtil.vanillaResource("village/plains/houses"), VersionUtil.lcResource("village/houses/idas_plains_gundam"), registryAccess, 1);
            }
            LightmansCurrency.LogInfo("Added custom Lightman's Currency village structures to their respective pools");
        }
        if (((Boolean)LCConfig.COMMON.structureAncientCity.get()).booleanValue()) {
            LCStructures.addToPool(VersionUtil.vanillaResource("ancient_city/structures"), VersionUtil.lcResource("ancient_city/ancient_ruins"), registryAccess, 2);
        }
    }

    private static void addToPool(@Nonnull ResourceLocation poolID, @Nonnull ResourceLocation toAdd, RegistryAccess registryAccess, int weight) {
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool pool = (StructureTemplatePool)registry.m_7745_(poolID);
        if (pool instanceof TemplatePoolAccess) {
            Holder<StructureProcessorList> processor;
            TemplatePoolAccess access = (TemplatePoolAccess)pool;
            if (!(access.getRawTemplates() instanceof ArrayList)) {
                access.setRawTemplates(new ArrayList<Pair<StructurePoolElement, Integer>>(access.getRawTemplates()));
            }
            SinglePoolElement newElement = (SinglePoolElement)((processor = LCStructures.lookupProcessorForStructure(toAdd, registryAccess)) == null ? SinglePoolElement.m_210526_((String)toAdd.toString()) : SinglePoolElement.m_210531_((String)toAdd.toString(), processor)).apply(StructureTemplatePool.Projection.RIGID);
            access.getRawTemplates().add((Pair<StructurePoolElement, Integer>)Pair.of((Object)newElement, (Object)weight));
            int oldCount = access.getTemplates().size();
            for (int i = 0; i < weight; ++i) {
                access.getTemplates().add((Object)newElement);
            }
            LightmansCurrency.LogDebug("Added " + toAdd + " to the " + poolID + " structure pool with a weight of " + weight + " (previously had " + oldCount + " total weight)");
        } else if (pool == null) {
            LightmansCurrency.LogWarning("Could not find StructureTemplatePool " + poolID);
        } else {
            LightmansCurrency.LogWarning("StructureTemplatePool Accessor Mixin was not set up correctly!\nWill be unable to add custom villager houses to the village pools.");
        }
    }

    @Nullable
    private static Holder<StructureProcessorList> lookupProcessorForStructure(@Nonnull ResourceLocation structure, RegistryAccess registryAccess) {
        Function getter = structureProcessors.getOrDefault(structure, null);
        return getter == null ? null : (Holder)getter.apply(registryAccess);
    }

    private static Function<RegistryAccess, Holder<StructureProcessorList>> easyGetter(@Nonnull String processorID) {
        return LCStructures.easyGetter(VersionUtil.lcResource(processorID));
    }

    private static Function<RegistryAccess, Holder<StructureProcessorList>> easyGetter(@Nonnull ResourceLocation processorID) {
        return LCStructures.easyGetter((ResourceKey<StructureProcessorList>)ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)processorID));
    }

    private static Function<RegistryAccess, Holder<StructureProcessorList>> easyGetter(@Nonnull ResourceKey<StructureProcessorList> key) {
        return registryAccess -> {
            HolderLookup.RegistryLookup registry = registryAccess.m_255025_(Registries.f_257011_);
            return registry.m_254902_(key).orElse(null);
        };
    }

    private static ResourceKey<StructureProcessorList> processorList(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)VersionUtil.lcResource(id));
    }

    private static ResourceKey<StructureSet> structureSet(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)VersionUtil.lcResource(id));
    }

    private static void debugPool(@Nonnull ResourceLocation poolID, @Nonnull RegistryAccess registryAccess) {
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool pool = (StructureTemplatePool)registry.m_7745_(poolID);
        if (pool instanceof TemplatePoolAccess) {
            TemplatePoolAccess access = (TemplatePoolAccess)pool;
            LightmansCurrency.LogDebug("Raw Entries for Pool '" + poolID + "':\n" + DebugUtil.debugList(access.getRawTemplates(), p -> ((StructurePoolElement)p.getFirst()).toString() + ";Weight: " + ((Integer)p.getSecond()).toString()));
            LightmansCurrency.LogDebug("Entries for Pool '" + poolID + "':\n" + DebugUtil.debugList(access.getTemplates()));
        }
    }

    static {
        PROCESSOR_DESERT_BANKER_ARCHAEOLOGY = LCStructures.processorList("desert_banker_archaeology");
        PROCESSOR_PLAINS_SHOP_ARCHAEOLOGY = LCStructures.processorList("plains_shop_archaeology");
        PROCESSOR_TAIGA_SHOP_ARCHAEOLOGY = LCStructures.processorList("taiga_shop_archaeology");
        PROCESSOR_DESERT_SHOP_ARCHAEOLOGY = LCStructures.processorList("desert_shop_archaeology");
        PROCESSOR_IDAS_TAIGA_LARGE_BANK = LCStructures.processorList("idas_taiga_large_bank");
        PROCESSOR_ANCIENT_RUINS = LCStructures.processorList("ancient_ruins");
        STRUCTURE_NETHER_RUINS = LCStructures.structureSet("nether_ruins");
        structureProcessors = new HashMap<ResourceLocation, Function<RegistryAccess, Holder<StructureProcessorList>>>();
        structureProcessors.put(VersionUtil.lcResource("village/houses/desert_banker"), LCStructures.easyGetter(PROCESSOR_DESERT_BANKER_ARCHAEOLOGY));
        structureProcessors.put(VersionUtil.lcResource("village/houses/plains_shop"), LCStructures.easyGetter(PROCESSOR_PLAINS_SHOP_ARCHAEOLOGY));
        structureProcessors.put(VersionUtil.lcResource("village/houses/taiga_shop"), LCStructures.easyGetter(PROCESSOR_TAIGA_SHOP_ARCHAEOLOGY));
        structureProcessors.put(VersionUtil.lcResource("village/houses/desert_shop"), LCStructures.easyGetter(PROCESSOR_DESERT_SHOP_ARCHAEOLOGY));
        structureProcessors.put(VersionUtil.lcResource("village/houses/idas_taiga_large_bank"), LCStructures.easyGetter(PROCESSOR_IDAS_TAIGA_LARGE_BANK));
        structureProcessors.put(VersionUtil.lcResource("ancient_city/ancient_ruins"), LCStructures.easyGetter(PROCESSOR_ANCIENT_RUINS));
    }
}

