/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Vector4d;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.client.screen.DimensionBookmarkButton;
import pepjebs.mapatlases.client.screen.MapWidget;
import pepjebs.mapatlases.client.screen.PinButton;
import pepjebs.mapatlases.client.screen.PinNameBox;
import pepjebs.mapatlases.client.screen.ShearButton;
import pepjebs.mapatlases.client.screen.SliceArrowButton;
import pepjebs.mapatlases.client.screen.SliceBookmarkButton;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.moonlight.MoonlightCompat;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.map_collection.MapKey;
import pepjebs.mapatlases.networking.C2SRemoveMapPacket;
import pepjebs.mapatlases.networking.C2SSelectSlicePacket;
import pepjebs.mapatlases.networking.C2STakeAtlasPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.DecorationHolder;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public class AtlasOverviewScreen
extends Screen {
    private final boolean bigTexture = MapAtlasesClientConfig.worldMapBigTexture.get();
    private final ResourceLocation texture = this.bigTexture ? MapAtlasesClient.ATLAS_BACKGROUND_TEXTURE_BIG : MapAtlasesClient.ATLAS_BACKGROUND_TEXTURE;
    private final int BOOK_WIDTH = this.bigTexture ? 290 : 162;
    private final int BOOK_HEIGHT = this.bigTexture ? 231 : 167;
    private final int H_BOOK_WIDTH = this.BOOK_WIDTH / 2;
    private final int H_BOOK_HEIGHT = this.BOOK_HEIGHT / 2;
    private final int MAP_WIDGET_WIDTH = this.bigTexture ? 256 : 128;
    private final int MAP_WIDGET_HEIGHT = this.bigTexture ? 192 : 128;
    private final int TEXTURE_W = this.bigTexture ? 512 : 256;
    private final int OVERLAY_UR = this.bigTexture ? 304 : 189;
    private final int OVERLAY_UL = this.bigTexture ? 309 : 194;
    private final ItemStack atlas;
    private final Player player;
    private final Level level;
    @Nullable
    private final LecternBlockEntity lectern;
    private MapWidget mapWidget;
    private PinNameBox editBox;
    private SliceBookmarkButton sliceButton;
    private SliceArrowButton sliceUp;
    private SliceArrowButton sliceDown;
    private final List<DecorationBookmarkButton> decorationBookmarks = new ArrayList<DecorationBookmarkButton>();
    private final List<DimensionBookmarkButton> dimensionBookmarks = new ArrayList<DimensionBookmarkButton>();
    public final float globalScale;
    private final boolean isPinOnly;
    private Slice selectedSlice;
    private boolean initialized = false;
    private boolean placingPin;
    private boolean shearing;
    private Pair<MapDataHolder, ColumnPos> partialPin = null;
    private PinButton pinButton;
    @NotNull
    private IMapCollection currentMaps;

    public AtlasOverviewScreen() {
        this(MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)Minecraft.m_91087_().f_91074_), null, false);
    }

    public AtlasOverviewScreen(ItemStack atlas, @Nullable LecternBlockEntity lectern, boolean placingPin) {
        super((Component)Component.m_237115_((String)MapAtlasesMod.MAP_ATLAS.get().m_5524_()));
        this.atlas = atlas;
        this.level = (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        this.player = (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        this.lectern = lectern;
        this.globalScale = lectern == null ? (float)MapAtlasesClientConfig.worldMapScale.get().doubleValue() : (float)MapAtlasesClientConfig.lecternWorldMapScale.get().doubleValue();
        this.currentMaps = MapAtlasItem.getMaps(atlas, this.level);
        MapDataHolder closest = this.getMapClosestToPlayer();
        this.selectedSlice = closest.slice;
        this.isPinOnly = placingPin;
        this.placingPin = placingPin;
        if (!this.isPinOnly) {
            this.player.m_5496_(MapAtlasesMod.ATLAS_OPEN_SOUND_EVENT.get(), (float)MapAtlasesClientConfig.soundScalar.get().doubleValue(), 1.0f);
        } else {
            this.partialPin = Pair.of((Object)closest, (Object)new ColumnPos(this.player.m_20183_().m_123341_(), this.player.m_20183_().m_123343_()));
        }
    }

    @NotNull
    private MapDataHolder getMapClosestToPlayer() {
        this.selectedSlice = MapAtlasItem.getSelectedSlice(this.atlas, (ResourceKey<Level>)this.player.m_9236_().m_46472_());
        MapDataHolder closest = this.currentMaps.getClosest(this.player, this.selectedSlice);
        if (closest == null) {
            closest = (MapDataHolder)this.currentMaps.getAll().stream().findFirst().get();
        }
        return closest;
    }

    public ItemStack getAtlas() {
        return this.atlas;
    }

    public Slice getSelectedSlice() {
        return this.selectedSlice;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.editBox = new PinNameBox(this.f_96547_, (this.f_96543_ - 100) / 2, (this.f_96544_ - 20) / 2, 100, 20, (Component)Component.m_237115_((String)"message.map_atlases.marker_name"), this::addNewPin);
        this.sliceButton = new SliceBookmarkButton((this.f_96543_ + this.BOOK_WIDTH) / 2 - 13, (this.f_96544_ - this.BOOK_HEIGHT) / 2 + (this.BOOK_HEIGHT - 36), this.selectedSlice, this);
        this.m_142416_((GuiEventListener)this.sliceButton);
        this.sliceUp = new SliceArrowButton(false, this.sliceButton, this);
        this.m_142416_((GuiEventListener)this.sliceUp);
        this.sliceDown = new SliceArrowButton(true, this.sliceButton, this);
        this.m_142416_((GuiEventListener)this.sliceDown);
        int i = 0;
        Collection<ResourceKey<Level>> dimensions = this.currentMaps.getAvailableDimensions();
        int separation = (int)Math.min(22.0f, ((float)this.BOOK_HEIGHT - 50.0f) / (float)dimensions.size());
        for (ResourceKey d : dimensions.stream().sorted(Comparator.comparingInt(e -> {
            String s = e.m_135782_().toString();
            if (MapAtlasesClient.DIMENSION_TEXTURE_ORDER.contains(s)) {
                return MapAtlasesClient.DIMENSION_TEXTURE_ORDER.indexOf(s);
            }
            return 999;
        })).toList()) {
            DimensionBookmarkButton pWidget = new DimensionBookmarkButton((this.f_96543_ + this.BOOK_WIDTH) / 2 - 10, (this.f_96544_ - this.BOOK_HEIGHT) / 2 + 15 + i * separation, (ResourceKey<Level>)d, this);
            this.m_142416_((GuiEventListener)pWidget);
            this.dimensionBookmarks.add(pWidget);
            ++i;
        }
        this.mapWidget = (MapWidget)this.m_142416_(new MapWidget((this.f_96543_ - this.MAP_WIDGET_WIDTH) / 2, (this.f_96544_ - this.MAP_WIDGET_HEIGHT) / 2 + (this.bigTexture ? 2 : 5), this.MAP_WIDGET_WIDTH, this.MAP_WIDGET_HEIGHT, 3, this, this.getMapClosestToPlayer()));
        this.m_7522_(this.mapWidget);
        int by = 0;
        if (!MapAtlasesConfig.pinMarkerId.get().isEmpty() && MapAtlasesMod.MOONLIGHT && MapAtlasesClientConfig.moonlightCompat.get().booleanValue()) {
            this.pinButton = new PinButton((this.f_96543_ + this.BOOK_WIDTH) / 2 + 20, (this.f_96544_ - this.BOOK_HEIGHT) / 2 + 16, this);
            this.m_142416_((GuiEventListener)this.pinButton);
            by += 20;
        }
        if (MapAtlasesConfig.shearButton.get().booleanValue()) {
            ShearButton shearButton = new ShearButton((this.f_96543_ + this.BOOK_WIDTH) / 2 + 20, (this.f_96544_ - this.BOOK_HEIGHT) / 2 + 16 + by, this);
            this.m_142416_((GuiEventListener)shearButton);
        }
        this.selectDimension((ResourceKey<Level>)this.level.m_46472_());
        if (this.lectern != null) {
            int pY = (int)(this.globalScale * (float)(this.f_96544_ + this.BOOK_HEIGHT + 4) / 2.0f);
            if (this.player.m_36326_()) {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, pY, 98, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"lectern.take_book"), button -> {
                    MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2STakeAtlasPacket(this.lectern.m_58899_()));
                    this.m_7379_();
                }).m_252987_(this.f_96543_ / 2 + 2, pY, 98, 20).m_253136_());
            } else {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, pY, 200, 20).m_253136_());
            }
        }
        if (this.isPinOnly) {
            this.focusEditBox(true);
        }
        this.initialized = true;
    }

    protected boolean isValid() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && (this.lectern == null || !this.lectern.m_58901_() && this.lectern.m_59566_().m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()) && !AtlasOverviewScreen.playerIsTooFarAwayToEdit((Player)this.f_96541_.f_91074_, this.lectern));
    }

    protected static boolean playerIsTooFarAwayToEdit(Player player, LecternBlockEntity tile) {
        return player.m_20275_((double)tile.m_58899_().m_123341_(), (double)tile.m_58899_().m_123342_(), (double)tile.m_58899_().m_123343_()) > 64.0;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        this.currentMaps = MapAtlasItem.getMaps(this.atlas, this.level);
        if (this.mapWidget != null) {
            this.mapWidget.tick();
        }
        if (this.editBox != null && this.editBox.f_93623_) {
            this.editBox.m_94120_();
        }
        if (!this.isValid()) {
            this.f_96541_.m_91152_(null);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256 && this.editBox.f_93623_) {
            this.editBox.f_93623_ = false;
            this.editBox.f_93624_ = false;
            this.partialPin = null;
            if (this.isPinOnly) {
                this.m_7379_();
            }
            return true;
        }
        if (!MapAtlasesClient.PLACE_PIN_KEYBIND.m_90862_() && MapAtlasesClient.PLACE_PIN_KEYBIND.m_90832_(pKeyCode, pScanCode)) {
            if (!this.isPinOnly && this.pinButton != null) {
                this.togglePlacingPin();
            }
            return true;
        }
        if (super.m_7933_(pKeyCode, pScanCode, pModifiers) || this.editBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (!this.editBox.f_93623_ && MapAtlasesClient.OPEN_ATLAS_KEYBIND.m_90832_(pKeyCode, pScanCode)) {
            this.m_7379_();
            return true;
        }
        for (DecorationBookmarkButton v : this.decorationBookmarks) {
            if (!v.m_7933_(pKeyCode, pScanCode, pModifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        for (DecorationBookmarkButton v : this.decorationBookmarks) {
            v.m_7920_(pKeyCode, pScanCode, pModifiers);
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        PoseStack poseStack = graphics.m_280168_();
        if (!this.isPinOnly) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
            poseStack.m_85841_(this.globalScale, this.globalScale, 1.0f);
            poseStack.m_85836_();
            RenderSystem.enableDepthTest();
            graphics.m_280163_(this.texture, -this.H_BOOK_WIDTH, -this.H_BOOK_HEIGHT, 0.0f, 0.0f, this.BOOK_WIDTH, this.BOOK_HEIGHT, this.TEXTURE_W, 256);
            graphics.m_280163_(MapAtlasesClient.ATLAS_OVERLAY_TEXTURE, -this.H_BOOK_WIDTH, -this.H_BOOK_HEIGHT, 0.0f, 0.0f, this.BOOK_WIDTH, this.BOOK_HEIGHT, this.TEXTURE_W, 256);
            poseStack.m_252880_(0.0f, 0.0f, 1.0f);
            graphics.m_280163_(this.texture, this.H_BOOK_WIDTH - 10, -this.H_BOOK_HEIGHT, (float)this.OVERLAY_UR, 0.0f, 5, this.BOOK_HEIGHT, this.TEXTURE_W, 256);
            graphics.m_280163_(this.texture, -this.H_BOOK_WIDTH + 5, -this.H_BOOK_HEIGHT, (float)this.OVERLAY_UL, 0.0f, 5, this.BOOK_HEIGHT, this.TEXTURE_W, 256);
            poseStack.m_85849_();
            poseStack.m_85836_();
            RenderSystem.enableDepthTest();
            poseStack.m_85837_((double)((float)(-this.f_96543_) / 2.0f), (double)((float)(-this.f_96544_) / 2.0f), 0.2);
            Vector4d v = this.transformMousePos(mouseX, mouseY);
            super.m_88315_(graphics, (int)v.x, (int)v.y, delta);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        RenderSystem.enableDepthTest();
        poseStack.m_252880_(0.0f, 0.0f, this.editBox.f_93623_ ? 22.0f : -20.0f);
        this.m_280273_(graphics);
        poseStack.m_85849_();
        if (this.editBox.f_93623_) {
            this.editBox.m_88315_(graphics, mouseX, mouseY, delta);
        } else if (MapAtlasesClientConfig.worldMapCrossair.get().booleanValue()) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 5.0f);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            graphics.m_280218_(MapAtlasesClient.GUI_ICONS_TEXTURE, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 0, 0, 15, 15);
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!this.editBox.f_93623_) {
            return super.m_6050_(mouseX, mouseY, amount);
        }
        return this.editBox.m_6050_(mouseX, mouseY, amount);
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        if (!this.editBox.f_93623_) {
            Vector4d v = this.transformMousePos(pMouseX, pMouseY);
            super.m_94757_(v.x, v.y);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.editBox.f_93623_) {
            Vector4d v = this.transformMousePos(pMouseX, pMouseY);
            return super.m_6375_(v.x, v.y, pButton);
        }
        return this.editBox.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.editBox.f_93623_) {
            Vector4d v = this.transformMousePos(pMouseX, pMouseY);
            return super.m_7979_(v.x, v.y, pButton, pDragX, pDragY);
        }
        return this.editBox.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public Vector4d transformMousePos(double mouseX, double mouseZ) {
        return AtlasOverviewScreen.scaleVector(mouseX, mouseZ, 1.0f / this.globalScale, this.f_96543_, this.f_96544_);
    }

    public Vector4d transformPos(double mouseX, double mouseZ) {
        return AtlasOverviewScreen.scaleVector(mouseX, mouseZ, this.globalScale, this.f_96543_, this.f_96544_);
    }

    public MapItemSavedData getCenterMapForSelectedDim() {
        if (this.selectedSlice.dimension().equals((Object)this.level.m_46472_())) {
            return this.getMapClosestToPlayer().data;
        }
        MapItemSavedData best = null;
        float averageX = 0.0f;
        float averageZ = 0.0f;
        int count = 0;
        for (MapDataHolder holder : this.currentMaps.selectSection(this.selectedSlice)) {
            MapItemSavedData d = holder.data;
            averageX += (float)d.f_256718_;
            averageZ += (float)d.f_256789_;
            ++count;
            if (!d.f_77894_.values().stream().anyMatch(e -> e.m_77803_().m_77856_())) continue;
            if (best != null) {
                if (!(Mth.m_211589_((double)best.f_256718_, (double)best.f_256789_) > Mth.m_211589_((double)d.f_256718_, (double)d.f_256789_))) continue;
                best = d;
                continue;
            }
            best = d;
        }
        if (best != null) {
            return best;
        }
        if (count == 0) {
            return null;
        }
        MapDataHolder closest = this.currentMaps.getClosest(averageX /= (float)count, averageZ /= (float)count, this.selectedSlice);
        if (closest == null) {
            boolean bl = true;
        }
        return closest == null ? null : closest.data;
    }

    @Nullable
    protected MapDataHolder findMapWithCenter(int reqXCenter, int reqZCenter) {
        return this.currentMaps.select(reqXCenter, reqZCenter, this.selectedSlice);
    }

    @Nullable
    protected MapDataHolder findMapContaining(int x, int z) {
        return this.currentMaps.select(MapKey.at(this.currentMaps.getScale(), x, z, this.selectedSlice));
    }

    public static String getReadableName(ResourceLocation id) {
        return AtlasOverviewScreen.getReadableName(id.m_135815_());
    }

    @NotNull
    public static String getReadableName(String s) {
        s = s.replace(".", " ").replace("_", " ");
        char[] array = s.toCharArray();
        array[0] = Character.toUpperCase(array[0]);
        for (int j = 1; j < array.length; ++j) {
            if (!Character.isWhitespace(array[j - 1])) continue;
            array[j] = Character.toUpperCase(array[j]);
        }
        return new String(array);
    }

    public void selectDimension(ResourceKey<Level> dimension) {
        MapItemSavedData center;
        boolean changedDim = this.selectedSlice.dimension().equals(dimension);
        if (changedDim) {
            this.selectedSlice = Slice.of(this.selectedSlice.type(), this.selectedSlice.height(), dimension);
        }
        this.updateSlice(!this.initialized ? this.selectedSlice : MapAtlasItem.getSelectedSlice(this.atlas, dimension));
        boolean isWherePlayerIs = this.level.m_46472_().equals(dimension);
        MapItemSavedData mapItemSavedData = center = isWherePlayerIs ? this.getMapClosestToPlayer().data : this.getCenterMapForSelectedDim();
        if (center == null) {
            boolean error = false;
            return;
        }
        this.mapWidget.resetAndCenter(center.f_256718_, center.f_256789_, isWherePlayerIs, changedDim);
        for (DimensionBookmarkButton v : this.dimensionBookmarks) {
            v.setSelected(v.getDimension().equals(dimension));
        }
        this.recalculateDecorationWidgets();
    }

    public void recalculateDecorationWidgets() {
        for (DecorationBookmarkButton v : this.decorationBookmarks) {
            this.m_169411_((GuiEventListener)v);
        }
        this.decorationBookmarks.clear();
        this.addDecorationWidgets();
    }

    public void updateVisibleDecoration(int currentXCenter, int currentZCenter, float radius, boolean followingPlayer) {
        if (this.decorationBookmarks.isEmpty()) {
            return;
        }
        float minX = (float)currentXCenter - radius;
        float maxX = (float)currentXCenter + radius;
        float minZ = (float)currentZCenter - radius;
        float maxZ = (float)currentZCenter + radius;
        ArrayList<Pair> byDistance = new ArrayList<Pair>();
        for (DecorationBookmarkButton bookmark : this.decorationBookmarks) {
            double x = bookmark.getWorldX();
            double z = bookmark.getWorldZ();
            if (x >= (double)minX && x <= (double)maxX && z >= (double)minZ && z <= (double)maxZ) {
                bookmark.setSelected(true);
            }
            if (!followingPlayer) continue;
            double distance = Mth.m_144952_((double)(x - (double)currentXCenter)) + Mth.m_144952_((double)(z - (double)currentZCenter));
            byDistance.add(Pair.of((Object)distance, (Object)((Object)bookmark)));
        }
        if (followingPlayer) {
            int index = 0;
            int maxW = this.BOOK_HEIGHT - 24;
            int separation = Math.min(17, maxW / byDistance.size());
            byDistance.sort(Comparator.comparingDouble(Pair::getFirst));
            for (Pair e : byDistance) {
                DecorationBookmarkButton d = (DecorationBookmarkButton)((Object)e.getSecond());
                d.m_253211_((this.f_96544_ - this.BOOK_HEIGHT) / 2 + 15 + index * separation);
                d.setIndex(index);
                ++index;
            }
        }
    }

    private void addDecorationWidgets() {
        if (!this.selectedSlice.hasMarkers()) {
            return;
        }
        ArrayList<DecorationHolder> mapIcons = new ArrayList<DecorationHolder>();
        boolean ml = MapAtlasesMod.MOONLIGHT;
        for (MapDataHolder holder : this.currentMaps.selectSection(this.selectedSlice)) {
            MapItemSavedData data = holder.data;
            for (Map.Entry d : data.f_77894_.entrySet()) {
                MapDecoration deco = (MapDecoration)d.getValue();
                if (!deco.m_77809_()) continue;
                mapIcons.add(new DecorationHolder(deco, (String)d.getKey(), holder));
            }
            if (!ml) continue;
            mapIcons.addAll(MoonlightCompat.getCustomDecorations(holder));
        }
        int i = 0;
        int separation = Math.min(17, (int)(((float)this.BOOK_HEIGHT - 22.0f) / (float)mapIcons.size()));
        ArrayList<DecorationBookmarkButton> widgets = new ArrayList<DecorationBookmarkButton>();
        for (DecorationHolder e : mapIcons) {
            DecorationBookmarkButton pWidget = DecorationBookmarkButton.of((this.f_96543_ - this.BOOK_WIDTH) / 2 + 10, (this.f_96544_ - this.BOOK_HEIGHT) / 2 + 15 + i * separation, e, this);
            pWidget.setIndex(i);
            widgets.add(pWidget);
            this.decorationBookmarks.add(pWidget);
            ++i;
        }
        widgets.sort(Comparator.comparingInt(DecorationBookmarkButton::getBatchGroup));
        widgets.forEach(x$0 -> {
            DecorationBookmarkButton cfr_ignored_0 = (DecorationBookmarkButton)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void centerOnDecoration(DecorationBookmarkButton button) {
        int x = (int)button.getWorldX();
        int z = (int)button.getWorldZ();
        this.mapWidget.resetAndCenter(x, z, false, true);
    }

    public boolean decreaseSlice() {
        int current = this.selectedSlice.heightOrTop();
        MapType type = this.selectedSlice.type();
        ResourceKey<Level> dim = this.selectedSlice.dimension();
        Integer newHeight = this.currentMaps.getHeightTree(dim, type).floor(current - 1);
        return this.updateSlice(Slice.of(type, newHeight, dim));
    }

    public boolean increaseSlice() {
        int current = this.selectedSlice.heightOrTop();
        MapType type = this.selectedSlice.type();
        ResourceKey<Level> dim = this.selectedSlice.dimension();
        Integer newHeight = this.currentMaps.getHeightTree(dim, type).ceiling(current + 1);
        return this.updateSlice(Slice.of(type, newHeight, dim));
    }

    public void cycleSliceType() {
        ResourceKey<Level> dim = this.selectedSlice.dimension();
        ArrayList<MapType> slices = new ArrayList<MapType>(this.currentMaps.getAvailableTypes(dim));
        if (!slices.isEmpty()) {
            int index = slices.indexOf((Object)this.selectedSlice.type());
            MapType type = slices.get(index = (index + 1) % slices.size());
            TreeSet<Integer> heightTree = this.currentMaps.getHeightTree(dim, type);
            Integer ceiling = heightTree.floor(this.selectedSlice.heightOrTop());
            if (ceiling == null) {
                ceiling = heightTree.first();
            }
            this.updateSlice(Slice.of(type, ceiling, dim));
        }
    }

    private boolean updateSlice(Slice newSlice) {
        ResourceKey<Level> dim;
        boolean changed = false;
        if (!Objects.equals(this.selectedSlice, newSlice)) {
            this.selectedSlice = newSlice;
            this.sliceButton.setSlice(this.selectedSlice);
            MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2SSelectSlicePacket(this.selectedSlice, this.lectern == null ? null : this.lectern.m_58899_()));
            MapAtlasItem.setSelectedSlice(this.atlas, this.selectedSlice);
            this.recalculateDecorationWidgets();
            changed = true;
        }
        boolean manySlices = this.currentMaps.getHeightTree(dim = this.selectedSlice.dimension(), this.selectedSlice.type()).size() > 1;
        boolean manyTypes = this.currentMaps.getAvailableTypes(dim).size() != 1;
        this.sliceButton.refreshState(manySlices, manyTypes);
        this.sliceDown.setActive(manySlices);
        this.sliceUp.setActive(manySlices);
        this.mapWidget.resetZoom();
        return changed;
    }

    public boolean isEditingText() {
        return this.editBox.f_93623_;
    }

    public boolean isPlacingPin() {
        return this.placingPin;
    }

    public void togglePlacingPin() {
        boolean bl = this.placingPin = !this.placingPin;
        if (this.placingPin) {
            this.shearing = false;
        }
    }

    public boolean isShearing() {
        return this.shearing;
    }

    public void toggleShearing() {
        boolean bl = this.shearing = !this.shearing;
        if (this.shearing) {
            this.placingPin = false;
        }
    }

    public void shearMapAt(ColumnPos pos) {
        MapDataHolder selected = this.findMapContaining(pos.f_140723_(), pos.f_140724_());
        if (selected != null) {
            MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2SRemoveMapPacket(selected.id));
            this.currentMaps.remove(selected);
            this.recalculateDecorationWidgets();
        }
        this.shearing = false;
    }

    public void placePinAt(ColumnPos pos) {
        MapDataHolder selected = this.findMapContaining(pos.f_140723_(), pos.f_140724_());
        if (selected != null) {
            this.editBox.m_94144_("");
            this.partialPin = Pair.of((Object)selected, (Object)pos);
            if (AtlasOverviewScreen.m_96638_() || AtlasOverviewScreen.m_96639_()) {
                this.focusEditBox(true);
            } else {
                this.addNewPin();
            }
        }
        this.placingPin = false;
    }

    private void focusEditBox(boolean on) {
        this.editBox.f_93623_ = on;
        this.editBox.f_93624_ = on;
        this.editBox.m_94190_(!on);
        this.editBox.m_93692_(on);
        this.m_7522_((GuiEventListener)(on ? this.editBox : this.mapWidget));
        if (!on && this.isPinOnly) {
            this.m_7379_();
        }
    }

    private void addNewPin() {
        if (this.partialPin != null) {
            String text = this.editBox.m_94155_();
            PinButton.placePin((MapDataHolder)this.partialPin.getFirst(), (ColumnPos)this.partialPin.getSecond(), text, this.editBox.getIndex());
            this.editBox.increasePinIndex();
            this.focusEditBox(false);
            this.partialPin = null;
            this.recalculateDecorationWidgets();
        }
    }

    public boolean canTeleport() {
        return AtlasOverviewScreen.m_96638_() && this.f_96541_.f_91072_.m_105295_().m_46408_() && !this.placingPin && !this.editBox.f_93623_;
    }

    public static Vector4d scaleVector(double mouseX, double mouseZ, float scale, int w, int h) {
        Matrix4d matrix4d = new Matrix4d();
        double translateX = (double)w / 2.0;
        double translateY = (double)h / 2.0;
        double scaleFactor = (double)scale - 1.0;
        matrix4d.translate(translateX, translateY, 0.0);
        matrix4d.scale(1.0 + scaleFactor);
        matrix4d.translate(-translateX, -translateY, 0.0);
        Vector4d v = new Vector4d(mouseX, mouseZ, 0.0, 1.0);
        matrix4d.transform(v);
        return v;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public void removeMapAt(double mouseX, double mouseY) {
        Vector4d v = this.transformMousePos(mouseX, mouseY);
        MapDataHolder map = this.currentMaps.select((int)v.x, (int)v.y, this.selectedSlice);
        if (map != null) {
            MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2SRemoveMapPacket(map.id));
        }
    }
}

