/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration.moonlight;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.DataObjectReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.PlatStuff;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.integration.moonlight.EntityPinMarker;

public class EntityRadar {
    private static final DataObjectReference<MapDecorationType<?, ?>> PASSIVE_PIN = new DataObjectReference(MapAtlasesMod.res("passive_entity"), MapDataRegistry.REGISTRY_KEY);
    private static final DataObjectReference<MapDecorationType<?, ?>> HOSTILE_PIN = new DataObjectReference(MapAtlasesMod.res("hostile_entity"), MapDataRegistry.REGISTRY_KEY);
    private static final DataObjectReference<MapDecorationType<?, ?>> NEUTRAL_PIN = new DataObjectReference(MapAtlasesMod.res("neutral_entity"), MapDataRegistry.REGISTRY_KEY);
    private static final DataObjectReference<MapDecorationType<?, ?>> BOSS_PIN = new DataObjectReference(MapAtlasesMod.res("boss_entity"), MapDataRegistry.REGISTRY_KEY);
    private static final WeakHashMap<Level, Set<MapBlockMarker<?>>> nearbyEntityMarkers = new WeakHashMap();
    private static final Map<Class<? extends LivingEntity>, DataObjectReference<MapDecorationType<?, ?>>> entityTypeMap = new Object2ObjectOpenHashMap();

    public static void onClientTick(Player player) {
        Level level = player.m_9236_();
        Set set = nearbyEntityMarkers.computeIfAbsent(level, k -> new HashSet());
        set.clear();
        Integer pValue = MapAtlasesClientConfig.radarRadius.get();
        List entities = level.m_45976_(LivingEntity.class, new AABB(player.m_20183_()).m_82377_((double)pValue.intValue(), 30.0, (double)pValue.intValue()).m_82386_(0.0, 2.0, 0.0));
        for (LivingEntity e : entities) {
            MapBlockMarker marker;
            DataObjectReference<MapDecorationType<?, ?>> type;
            if (e == player || (type = EntityRadar.getMarkerForType(e)) == null || !((marker = ((MapDecorationType)type.get()).createEmptyMarker()) instanceof EntityPinMarker)) continue;
            EntityPinMarker m = (EntityPinMarker)marker;
            m.setPos(new BlockPos(e.m_146903_(), e.m_146904_(), e.m_146907_()));
            m.setEntity((Entity)e);
            set.add(marker);
        }
    }

    @Nullable
    public static DataObjectReference<MapDecorationType<?, ?>> getMarkerForType(LivingEntity entity) {
        return entityTypeMap.computeIfAbsent(entity.getClass(), clazz -> {
            EntityType type = entity.m_6095_();
            if (type == EntityType.f_20532_) {
                return null;
            }
            if (PlatStuff.isBoss(type)) {
                return BOSS_PIN;
            }
            if (entity instanceof Enemy) {
                return HOSTILE_PIN;
            }
            if (entity instanceof NeutralMob) {
                return NEUTRAL_PIN;
            }
            if (entity instanceof Animal) {
                return PASSIVE_PIN;
            }
            return null;
        });
    }

    public static Set<MapBlockMarker<?>> send(Integer integer, MapItemSavedData data) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (data.f_77887_.equals(level.m_46472_())) {
            return nearbyEntityMarkers.computeIfAbsent((Level)level, j -> new HashSet());
        }
        return Set.of();
    }

    public static void unloadLevel() {
        nearbyEntityMarkers.clear();
    }
}

